"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PanelHeaderItems = void 0;
var _eui = require("@elastic/eui");
var _react = require("@emotion/react");
var _react2 = _interopRequireDefault(require("react"));
var _kibana = require("../../contexts/kibana");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const PanelHeaderItems = ({
  headerItems,
  compressed = false
}) => {
  const {
    euiTheme
  } = (0, _kibana.useCurrentThemeVars)();
  return /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: compressed ? 's' : 'l',
    alignItems: 'center'
  }, headerItems.map((item, i) => {
    return /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
      key: i,
      grow: false
    }, /*#__PURE__*/_react2.default.createElement("div", {
      css: i < (headerItems === null || headerItems === void 0 ? void 0 : headerItems.length) - 1 ? (0, _react.css)`
                      border-right: ${euiTheme.euiBorderWidthThin} solid ${euiTheme.euiBorderColor};
                      padding-right: ${compressed ? euiTheme.euiPanelPaddingModifiers.paddingSmall : euiTheme.euiPanelPaddingModifiers.paddingLarge};
                    ` : null
    }, item));
  }));
};
exports.PanelHeaderItems = PanelHeaderItems;