"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.OverviewStatsBar = exports.CollapsiblePanel = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _panel_header_items = require("./panel_header_items");
var _kibana = require("../../contexts/kibana");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const CollapsiblePanel = ({
  isOpen,
  onToggle,
  children,
  header,
  headerItems,
  ariaLabel
}) => {
  const {
    euiTheme
  } = (0, _kibana.useCurrentThemeVars)();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiSplitPanel.Outer, {
    grow: true,
    hasShadow: false,
    css: {
      border: `${euiTheme.euiBorderWidthThin} solid ${isOpen ? euiTheme.euiBorderColor : 'transparent'}`
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSplitPanel.Inner, {
    color: isOpen ? 'plain' : 'subdued'
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: 'spaceBetween',
    alignItems: 'center'
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: 's'
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    "aria-label": isOpen ? _i18n.i18n.translate('xpack.ml.collapsiblePanel.toggleClose', {
      defaultMessage: 'Close {ariaLabel}',
      values: {
        ariaLabel
      }
    }) : _i18n.i18n.translate('xpack.ml.collapsiblePanel.toggleOpen', {
      defaultMessage: 'Open {ariaLabel}',
      values: {
        ariaLabel
      }
    }),
    color: 'text',
    iconType: isOpen ? 'arrowDown' : 'arrowRight',
    onClick: () => {
      onToggle(!isOpen);
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xxs"
  }, /*#__PURE__*/_react.default.createElement("h2", null, header))))), headerItems ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_panel_header_items.PanelHeaderItems, {
    headerItems: headerItems
  })) : null)), isOpen ? /*#__PURE__*/_react.default.createElement(_eui.EuiSplitPanel.Inner, {
    css: {
      borderTop: `${euiTheme.euiBorderWidthThin} solid ${euiTheme.euiBorderColor}`
    },
    grow: false
  }, children) : null);
};
exports.CollapsiblePanel = CollapsiblePanel;
const OverviewStatsBar = ({
  inputStats,
  dataTestSub
}) => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    "data-test-subj": dataTestSub,
    alignItems: 'center',
    gutterSize: 'm'
  }, inputStats.map(({
    value,
    label,
    'data-test-subj': dataTestSubjValue
  }) => {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      key: label
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      alignItems: 'center',
      gutterSize: 's'
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: 's'
    }, label, ":")), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
      "data-test-subj": dataTestSubjValue
    }, value))));
  }));
};
exports.OverviewStatsBar = OverviewStatsBar;