"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AccessDeniedCallout = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _check_capabilities = require("../capabilities/check_capabilities");
var _help_menu = require("../components/help_menu");
var _kibana = require("../contexts/kibana");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const AccessDeniedCallout = ({
  missingCapabilities
}) => {
  const {
    services: {
      docLinks
    }
  } = (0, _kibana.useMlKibana)();
  const helpLink = docLinks.links.ml.guide;
  const errorMessages = (missingCapabilities !== null && missingCapabilities !== void 0 ? missingCapabilities : []).map(c => (0, _check_capabilities.createPermissionFailureMessage)(c));
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPageTemplate.EmptyPrompt, {
    color: 'danger',
    alignment: 'horizontalCenter',
    iconType: "warning",
    title: /*#__PURE__*/_react.default.createElement("h2", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.management.jobsList.accessDeniedTitle",
      defaultMessage: "Access denied"
    })),
    body: /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.accessDenied.description",
      defaultMessage: "You do not have permission to view this page."
    }), errorMessages ? /*#__PURE__*/_react.default.createElement("ul", null, errorMessages.map(v => /*#__PURE__*/_react.default.createElement("li", {
      key: v
    }, v))) : null)
  }), /*#__PURE__*/_react.default.createElement(_help_menu.HelpMenu, {
    docLink: helpLink
  }));
};
exports.AccessDeniedCallout = AccessDeniedCallout;