"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.diskWriteThroughput = exports.diskUsageAverage = exports.diskUsage = exports.diskSpaceAvailable = exports.diskSpaceAvailability = exports.diskReadThroughput = exports.diskIOWrite = exports.diskIORead = void 0;
var _constants = require("../../../shared/charts/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const diskIORead = exports.diskIORead = {
  label: _constants.DISK_READ_IOPS_LABEL,
  value: "counter_rate(max(system.diskio.read.count), kql='system.diskio.read.count: *')",
  format: 'number',
  decimals: 0,
  normalizeByUnit: 's'
};
const diskReadThroughput = exports.diskReadThroughput = {
  label: _constants.DISK_READ_THROUGHPUT_LABEL,
  value: "counter_rate(max(system.diskio.read.bytes), kql='system.diskio.read.bytes: *')",
  format: 'bytes',
  decimals: 1,
  normalizeByUnit: 's'
};
const diskSpaceAvailable = exports.diskSpaceAvailable = {
  label: _constants.DISK_SPACE_AVAILABLE_LABEL,
  value: 'average(system.filesystem.free)',
  format: 'bytes',
  decimals: 0
};
const diskSpaceAvailability = exports.diskSpaceAvailability = {
  label: _constants.DISK_SPACE_AVAILABILITY_LABEL,
  value: '1 - average(system.filesystem.used.pct)',
  format: 'percent',
  decimals: 0
};
const diskUsage = exports.diskUsage = {
  label: _constants.DISK_USAGE_LABEL,
  value: 'max(system.filesystem.used.pct)',
  format: 'percent',
  decimals: 0
};
const diskUsageAverage = exports.diskUsageAverage = {
  label: _constants.DISK_USAGE_AVERAGE_LABEL,
  value: 'average(system.filesystem.used.pct)',
  format: 'percent',
  decimals: 0
};
const diskIOWrite = exports.diskIOWrite = {
  label: _constants.DISK_WRITE_IOPS_LABEL,
  value: "counter_rate(max(system.diskio.write.count), kql='system.diskio.write.count: *')",
  format: 'number',
  decimals: 0,
  normalizeByUnit: 's'
};
const diskWriteThroughput = exports.diskWriteThroughput = {
  label: _constants.DISK_WRITE_THROUGHPUT_LABEL,
  value: "counter_rate(max(system.diskio.write.bytes), kql='system.diskio.write.bytes: *')",
  format: 'bytes',
  decimals: 1,
  normalizeByUnit: 's'
};