"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.metrics = exports.containerSnapshotMetricTypes = void 0;
var _cpu = require("./snapshot/cpu");
var _memory = require("./snapshot/memory");
var _rx = require("./snapshot/rx");
var _tx = require("./snapshot/tx");
var _container_cpu_kernel = require("./tsvb/container_cpu_kernel");
var _container_cpu_usage = require("./tsvb/container_cpu_usage");
var _container_diskio_ops = require("./tsvb/container_diskio_ops");
var _container_disk_io_bytes = require("./tsvb/container_disk_io_bytes");
var _container_k8s_cpu_usage = require("./tsvb/container_k8s_cpu_usage");
var _container_k8s_memory_usage = require("./tsvb/container_k8s_memory_usage");
var _container_k8s_overview = require("./tsvb/container_k8s_overview");
var _container_memory = require("./tsvb/container_memory");
var _container_network_traffic = require("./tsvb/container_network_traffic");
var _container_overview = require("./tsvb/container_overview");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const containerSnapshotMetrics = {
  cpu: _cpu.cpu,
  memory: _memory.memory,
  rx: _rx.rx,
  tx: _tx.tx
};
const containerSnapshotMetricTypes = exports.containerSnapshotMetricTypes = Object.keys(containerSnapshotMetrics);
const metrics = exports.metrics = {
  tsvb: {
    containerOverview: _container_overview.containerOverview,
    containerCpuUsage: _container_cpu_usage.containerCpuUsage,
    containerCpuKernel: _container_cpu_kernel.containerCpuKernel,
    containerDiskIOOps: _container_diskio_ops.containerDiskIOOps,
    containerDiskIOBytes: _container_disk_io_bytes.containerDiskIOBytes,
    containerNetworkTraffic: _container_network_traffic.containerNetworkTraffic,
    containerMemory: _container_memory.containerMemory,
    containerK8sCpuUsage: _container_k8s_cpu_usage.containerK8sCpuUsage,
    containerK8sOverview: _container_k8s_overview.containerK8sOverview,
    containerK8sMemoryUsage: _container_k8s_memory_usage.containerK8sMemoryUsage
  },
  snapshot: containerSnapshotMetrics,
  getFormulas: async () => await Promise.resolve().then(() => _interopRequireWildcard(require('./formulas'))).then(({
    formulas
  }) => formulas),
  getCharts: async () => await Promise.resolve().then(() => _interopRequireWildcard(require('./charts'))).then(({
    charts
  }) => charts),
  defaultSnapshot: 'cpu',
  defaultTimeRangeInSeconds: 3600 // 1 hour
};