"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.title = exports.regionMapVisType = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _sharedUxUtility = require("@kbn/shared-ux-utility");
var _to_ast = require("./to_ast");
var _types = require("./types");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const title = exports.title = _i18n.i18n.translate('xpack.maps.regionMapMap.vis.title', {
  defaultMessage: 'Region Map'
});
const LazyRegionMapEditor = function (props) {
  const Component = (0, _sharedUxUtility.dynamic)(async () => {
    const {
      RegionMapEditor
    } = await Promise.resolve().then(() => _interopRequireWildcard(require('./region_map_editor')));
    return {
      default: RegionMapEditor
    };
  });
  return /*#__PURE__*/_react.default.createElement(Component, props);
};
const regionMapVisType = exports.regionMapVisType = {
  name: _types.REGION_MAP_VIS_TYPE,
  title,
  icon: 'visMapRegion',
  description: _i18n.i18n.translate('xpack.maps.regionMap.vis.description', {
    defaultMessage: 'Show metrics on a thematic map.'
  }),
  editorConfig: {
    optionTabs: [{
      name: '',
      title: '',
      editor: LazyRegionMapEditor
    }]
  },
  visConfig: {
    defaults: {
      colorSchema: 'Yellow to Red',
      mapZoom: 2,
      mapCenter: [0, 0]
    }
  },
  toExpressionAst: _to_ast.toExpressionAst,
  requiresSearch: true,
  disableCreate: true
};