"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SetViewForm = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _react2 = require("@emotion/react");
var _decimal_degrees_form = require("./decimal_degrees_form");
var _mgrs_form = require("./mgrs_form");
var _utm_form = require("./utm_form");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DEGREES_DECIMAL = 'dd';
const MGRS = 'mgrs';
const UTM = 'utm';
const COORDINATE_SYSTEM_OPTIONS = [{
  id: DEGREES_DECIMAL,
  label: _i18n.i18n.translate('xpack.maps.setViewControl.decimalDegreesLabel', {
    defaultMessage: 'Decimal degrees'
  })
}, {
  id: UTM,
  label: 'UTM'
}, {
  id: MGRS,
  label: 'MGRS'
}];
const SetViewForm = exports.SetViewForm = /*#__PURE__*/_react.default.memo(({
  settings,
  zoom,
  center,
  onSubmit
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const [coordinateSystem, setCoordinateSystem] = (0, _react.useState)(DEGREES_DECIMAL);
  const onCoordinateSystemChange = (0, _react.useCallback)(optionId => {
    setCoordinateSystem(optionId);
  }, []);
  const renderForm = () => {
    switch (coordinateSystem) {
      case MGRS:
        return /*#__PURE__*/_react.default.createElement(_mgrs_form.MgrsForm, {
          settings: settings,
          zoom: zoom,
          center: center,
          onSubmit: onSubmit
        });
      case UTM:
        return /*#__PURE__*/_react.default.createElement(_utm_form.UtmForm, {
          settings: settings,
          zoom: zoom,
          center: center,
          onSubmit: onSubmit
        });
      default:
        return /*#__PURE__*/_react.default.createElement(_decimal_degrees_form.DecimalDegreesForm, {
          settings: settings,
          zoom: zoom,
          center: center,
          onSubmit: onSubmit
        });
    }
  };
  return /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": "mapSetViewForm",
    css: (0, _react2.css)`
        width: 240px;
      `
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      gutterSize: "s"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: "controlsHorizontal"
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.maps.setViewControl.changeCoordinateSystemButtonLabel",
      defaultMessage: "Coordinate system"
    }))),
    css: (0, _react2.css)`
          border-bottom: 1px solid ${euiTheme.colors.backgroundLightText};
          margin-bottom: ${euiTheme.size.s};
          padding-bottom: ${euiTheme.size.s};
        `
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiRadioGroup, {
    options: COORDINATE_SYSTEM_OPTIONS,
    idSelected: coordinateSystem,
    onChange: onCoordinateSystemChange
  })), renderForm());
});
SetViewForm.displayName = 'SetViewForm';