"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.VectorStyleLabelEditor = VectorStyleLabelEditor;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _style_prop_editor = require("../style_prop_editor");
var _dynamic_label_form = require("./dynamic_label_form");
var _static_label_form = require("./static_label_form");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function VectorStyleLabelEditor(props) {
  const labelForm = props.styleProperty.isDynamic() ? /*#__PURE__*/_react.default.createElement(_dynamic_label_form.DynamicLabelForm, (0, _extends2.default)({}, props, {
    styleProperty: props.styleProperty
  })) : /*#__PURE__*/_react.default.createElement(_static_label_form.StaticLabelForm, (0, _extends2.default)({}, props, {
    styleProperty: props.styleProperty
  }));
  return /*#__PURE__*/_react.default.createElement(_style_prop_editor.StylePropEditor, props, labelForm);
}