"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MVTFieldConfigEditor = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _reactField = require("@kbn/react-field");
var _lodash = _interopRequireDefault(require("lodash"));
var _constants = require("../../../../common/constants");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function makeOption({
  value,
  icon,
  message
}) {
  return {
    value,
    inputDisplay: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      gutterSize: "s",
      alignItems: "center"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: null
    }, /*#__PURE__*/_react.default.createElement(_reactField.FieldIcon, {
      type: icon,
      fill: "none"
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, message))
  };
}
const FIELD_TYPE_OPTIONS = [{
  value: _constants.MVT_FIELD_TYPE.STRING,
  icon: 'string',
  message: _i18n.i18n.translate('xpack.maps.mvtSource.stringFieldLabel', {
    defaultMessage: 'string'
  })
}, {
  value: _constants.MVT_FIELD_TYPE.NUMBER,
  icon: 'number',
  message: _i18n.i18n.translate('xpack.maps.mvtSource.numberFieldLabel', {
    defaultMessage: 'number'
  })
}].map(makeOption);
class MVTFieldConfigEditor extends _react.Component {
  constructor(...args) {
    super(...args);
    (0, _defineProperty2.default)(this, "state", {
      currentFields: _lodash.default.cloneDeep(this.props.fields)
    });
    (0, _defineProperty2.default)(this, "_notifyChange", _lodash.default.debounce(() => {
      const invalid = this.state.currentFields.some(field => {
        return field.name === '';
      });
      if (!invalid) {
        this.props.onChange(this.state.currentFields);
      }
    }));
    (0, _defineProperty2.default)(this, "_addField", () => {
      const newFields = this.state.currentFields.slice();
      newFields.push({
        type: _constants.MVT_FIELD_TYPE.STRING,
        name: ''
      });
      this._fieldChange(newFields);
    });
  }
  _fieldChange(newFields) {
    this.setState({
      currentFields: newFields
    }, this._notifyChange);
  }
  _removeField(index) {
    const newFields = this.state.currentFields.slice();
    newFields.splice(index, 1);
    this._fieldChange(newFields);
  }
  _renderFieldTypeDropDown(mvtFieldConfig, index) {
    const onChange = type => {
      const newFields = this.state.currentFields.slice();
      newFields[index] = {
        type,
        name: newFields[index].name
      };
      this._fieldChange(newFields);
    };
    return /*#__PURE__*/_react.default.createElement(_eui.EuiSuperSelect, {
      options: FIELD_TYPE_OPTIONS,
      valueOfSelected: mvtFieldConfig.type,
      onChange: value => onChange(value),
      compressed: true
    });
  }
  _renderFieldButtonDelete(index) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
      iconType: "trash",
      color: "danger",
      onClick: () => {
        this._removeField(index);
      },
      title: _i18n.i18n.translate('xpack.maps.mvtSource.trashButtonTitle', {
        defaultMessage: 'Remove field'
      }),
      "aria-label": _i18n.i18n.translate('xpack.maps.mvtSource.trashButtonAriaLabel', {
        defaultMessage: 'Remove field'
      })
    });
  }
  _renderFieldNameInput(mvtFieldConfig, index) {
    const onChange = e => {
      const name = e.target.value;
      const newFields = this.state.currentFields.slice();
      newFields[index] = {
        name,
        type: newFields[index].type
      };
      this._fieldChange(newFields);
    };
    const emptyName = mvtFieldConfig.name === '';
    const hasDupes = this.state.currentFields.filter(field => field.name === mvtFieldConfig.name).length > 1;
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
      value: mvtFieldConfig.name,
      onChange: onChange,
      "aria-label": 'Fieldname',
      placeholder: _i18n.i18n.translate('xpack.maps.mvtSource.fieldPlaceholderText', {
        defaultMessage: 'Field name'
      }),
      isInvalid: emptyName || hasDupes,
      compressed: true
    });
  }
  _renderFieldConfig() {
    return this.state.currentFields.map((mvtFieldConfig, index) => {
      return /*#__PURE__*/_react.default.createElement(_react.Fragment, {
        key: index
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        gutterSize: "xs",
        alignItems: "center"
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, this._renderFieldNameInput(mvtFieldConfig, index)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, this._renderFieldTypeDropDown(mvtFieldConfig, index)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false
      }, this._renderFieldButtonDelete(index))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
        size: 'xs'
      }));
    });
  }
  render() {
    return /*#__PURE__*/_react.default.createElement(_react.Fragment, null, this._renderFieldConfig(), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: 's'
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      justifyContent: "spaceAround",
      alignItems: "center",
      gutterSize: "xs"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      onClick: this._addField,
      size: "xs",
      iconType: "plusInCircleFilled"
    }, _i18n.i18n.translate('xpack.maps.mvtSource.addFieldLabel', {
      defaultMessage: 'Add'
    })))));
  }
}
exports.MVTFieldConfigEditor = MVTFieldConfigEditor;