"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.syncBoundsData = syncBoundsData;
var _constants = require("../../../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function syncBoundsData({
  layerId,
  syncContext,
  source,
  sourceQuery
}) {
  const {
    startLoading,
    stopLoading,
    registerCancelCallback,
    dataFilters,
    isFeatureEditorOpenForLayer
  } = syncContext;
  const requestToken = Symbol(`${_constants.SOURCE_BOUNDS_DATA_REQUEST_ID}-${layerId}`);

  // Do not pass all requestMeta to source.getBoundsForFilters().
  // For example, do not want to filter bounds request by extent and buffer.
  const boundsFilters = {
    sourceQuery: sourceQuery ? sourceQuery : undefined,
    query: dataFilters.query,
    timeFilters: dataFilters.timeFilters,
    timeslice: dataFilters.timeslice,
    embeddableSearchContext: dataFilters.embeddableSearchContext,
    filters: dataFilters.filters,
    joinKeyFilter: dataFilters.joinKeyFilter,
    applyGlobalQuery: source.getApplyGlobalQuery(),
    applyGlobalTime: source.getApplyGlobalTime(),
    isFeatureEditorOpenForLayer,
    executionContext: dataFilters.executionContext
  };
  let bounds = null;
  try {
    startLoading(_constants.SOURCE_BOUNDS_DATA_REQUEST_ID, requestToken, boundsFilters);
    bounds = await source.getBoundsForFilters(boundsFilters, registerCancelCallback.bind(null, requestToken));
  } finally {
    // Use stopLoading callback instead of onLoadError callback.
    // Function is loading bounds and not feature data.
    stopLoading(_constants.SOURCE_BOUNDS_DATA_REQUEST_ID, requestToken, bounds ? bounds : {});
  }
  return bounds;
}