"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.InvalidLayer = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _i18n = require("@kbn/i18n");
var _layer = require("./layer");
var _source = require("../sources/source");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/* eslint-disable max-classes-per-file */

class InvalidSource extends _source.AbstractSource {
  constructor(id) {
    super({
      id,
      type: 'INVALID'
    });
  }
}
class InvalidLayer extends _layer.AbstractLayer {
  constructor(layerDescriptor, error) {
    var _layerDescriptor$sour;
    super({
      layerDescriptor,
      source: new InvalidSource((_layerDescriptor$sour = layerDescriptor.sourceDescriptor) === null || _layerDescriptor$sour === void 0 ? void 0 : _layerDescriptor$sour.id)
    });
    (0, _defineProperty2.default)(this, "_error", void 0);
    (0, _defineProperty2.default)(this, "_style", void 0);
    this._error = error;
    this._style = {
      getType() {
        return 'INVALID';
      },
      renderEditor() {
        return null;
      }
    };
  }
  isLayerLoading() {
    return false;
  }
  hasErrors() {
    return true;
  }
  getErrors() {
    return [{
      title: _i18n.i18n.translate('xpack.maps.invalidLayer.errorTitle', {
        defaultMessage: `Unable to create layer`
      }),
      body: this._error.message
    }];
  }
  getStyleForEditing() {
    return this._style;
  }
  getStyle() {
    return this._style;
  }
  getCurrentStyle() {
    return this._style;
  }
  getMbLayerIds() {
    return [];
  }
  ownsMbLayerId() {
    return false;
  }
  ownsMbSourceId() {
    return false;
  }
  syncLayerWithMB() {}
  getLayerTypeIconName() {
    return 'error';
  }
}
exports.InvalidLayer = InvalidLayer;