"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SolutionEmptyPrompt = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _sharedUxPageKibanaTemplate = require("@kbn/shared-ux-page-kibana-template");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const IndicesLink = ({
  coreStart
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
  href: coreStart.application.getUrlForApp('management', {
    path: 'data/index_management'
  }),
  "data-test-subj": "managementLinkToIndices"
}, _i18n.i18n.translate('management.landing.subhead.indicesLink', {
  defaultMessage: 'indices'
}));
const DataViewsLink = ({
  coreStart
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
  href: coreStart.application.getUrlForApp('management', {
    path: 'kibana/dataViews'
  }),
  "data-test-subj": "managementLinkToDataViews"
}, _i18n.i18n.translate('management.landing.subhead.dataViewsLink', {
  defaultMessage: 'data views'
}));
const IngestPipelinesLink = ({
  coreStart
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
  href: coreStart.application.getUrlForApp('management', {
    path: 'ingest/ingest_pipelines'
  }),
  "data-test-subj": "managementLinkToIngestPipelines"
}, _i18n.i18n.translate('management.landing.subhead.ingestPipelinesLink', {
  defaultMessage: 'ingest pipelines'
}));
const UsersLink = ({
  coreStart
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
  href: coreStart.application.getUrlForApp('management', {
    path: 'security/users'
  }),
  "data-test-subj": "managementLinkToUsers"
}, _i18n.i18n.translate('management.landing.subhead.usersLink', {
  defaultMessage: 'users'
}));
const SolutionEmptyPrompt = ({
  kibanaVersion,
  coreStart
}) => {
  return /*#__PURE__*/_react.default.createElement(_sharedUxPageKibanaTemplate.KibanaPageTemplate.EmptyPrompt, {
    "data-test-subj": "managementHomeSolution",
    iconType: "managementApp",
    title: /*#__PURE__*/_react.default.createElement("h1", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "management.landing.solution.header",
      defaultMessage: "Stack Management {version}",
      values: {
        version: kibanaVersion
      }
    })),
    body: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "management.landing.solution.subhead",
      defaultMessage: "Manage your {indicesLink}, {dataViewsLink}, {ingestPipelinesLink}, {usersLink}, and more.",
      values: {
        indicesLink: /*#__PURE__*/_react.default.createElement(IndicesLink, {
          coreStart: coreStart
        }),
        dataViewsLink: /*#__PURE__*/_react.default.createElement(DataViewsLink, {
          coreStart: coreStart
        }),
        ingestPipelinesLink: /*#__PURE__*/_react.default.createElement(IngestPipelinesLink, {
          coreStart: coreStart
        }),
        usersLink: /*#__PURE__*/_react.default.createElement(UsersLink, {
          coreStart: coreStart
        })
      }
    })), /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      fill: true,
      iconType: "spaces",
      onClick: () => {
        coreStart.chrome.sideNav.setPanelSelectedNode('stack_management');
      },
      "data-test-subj": "viewAllStackMngtPagesButton"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "management.landing.solution.viewAllPagesButton",
      defaultMessage: "View all pages"
    }))))
  });
};
exports.SolutionEmptyPrompt = SolutionEmptyPrompt;