"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isTimestampColumn = exports.isMessageColumn = exports.isFieldSegment = exports.isFieldColumn = exports.isConstantSegment = exports.getUniqueLogEntryKey = exports.getLogEntryKey = exports.getLogEntryIndexBeforeTime = exports.getLogEntryIndexAtTime = exports.getLogEntryIndexAfterTime = exports.getLogEntryAtTime = void 0;
var _d3Array = require("d3-array");
var _time = require("../../../common/time");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getLogEntryKey = entry => entry.cursor;
exports.getLogEntryKey = getLogEntryKey;
const getUniqueLogEntryKey = entry => ({
  ...entry.cursor,
  gid: entry.id
});
exports.getUniqueLogEntryKey = getUniqueLogEntryKey;
const logEntryTimeBisector = (0, _d3Array.bisector)((0, _time.compareToTimeKey)(getLogEntryKey));
const getLogEntryIndexBeforeTime = exports.getLogEntryIndexBeforeTime = logEntryTimeBisector.left;
const getLogEntryIndexAfterTime = exports.getLogEntryIndexAfterTime = logEntryTimeBisector.right;
const getLogEntryIndexAtTime = exports.getLogEntryIndexAtTime = (0, _time.getIndexAtTimeKey)(getLogEntryKey);
const getLogEntryAtTime = (entries, time) => {
  const entryIndex = getLogEntryIndexAtTime(entries, time);
  return entryIndex !== null ? entries[entryIndex] : null;
};
exports.getLogEntryAtTime = getLogEntryAtTime;
const isTimestampColumn = column => column != null && 'time' in column;
exports.isTimestampColumn = isTimestampColumn;
const isMessageColumn = column => column != null && 'message' in column;
exports.isMessageColumn = isMessageColumn;
const isFieldColumn = column => column != null && 'field' in column;
exports.isFieldColumn = isFieldColumn;
const isConstantSegment = segment => 'constant' in segment;
exports.isConstantSegment = isConstantSegment;
const isFieldSegment = segment => 'field' in segment && 'value' in segment;
exports.isFieldSegment = isFieldSegment;