"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useLogViewContext = exports.useLogView = exports.LogViewProvider = void 0;
var _react = require("@xstate/react");
var _constate = _interopRequireDefault(require("constate"));
var _react2 = require("react");
var _waitFor = require("xstate/lib/waitFor");
var _log_views = require("../../common/log_views");
var _log_view_state = require("../observability_logs/log_view_state");
var _dev_mode = require("../utils/dev_mode");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useLogView = ({
  initialLogViewReference,
  logViews,
  useDevTools = (0, _dev_mode.isDevMode)(),
  initializeFromUrl,
  updateContextInUrl,
  listenForUrlChanges
}) => {
  const [logViewStateNotifications] = (0, _react2.useState)(() => (0, _log_view_state.createLogViewNotificationChannel)());
  const logViewStateService = (0, _react.useInterpret)(() => (0, _log_view_state.createLogViewStateMachine)({
    initialContext: {
      logViewReference: initialLogViewReference !== null && initialLogViewReference !== void 0 ? initialLogViewReference : _log_views.DEFAULT_LOG_VIEW
    },
    logViews,
    notificationChannel: logViewStateNotifications,
    initializeFromUrl,
    updateContextInUrl,
    listenForUrlChanges
  }), {
    devTools: useDevTools
  });
  const changeLogViewReference = (0, _react2.useCallback)(logViewReference => {
    logViewStateService.send({
      type: 'LOG_VIEW_REFERENCE_CHANGED',
      logViewReference
    });
  }, [logViewStateService]);
  const logViewReference = (0, _react.useSelector)(logViewStateService, state => state.context.logViewReference);
  const logView = (0, _react.useSelector)(logViewStateService, state => state.matches('resolving') || state.matches('updating') || state.matches('checkingStatus') || state.matches('resolutionFailed') || state.matches('checkingStatusFailed') || state.matches('resolvedPersistedLogView') || state.matches('resolvedInlineLogView') ? state.context.logView : undefined);
  const resolvedLogView = (0, _react.useSelector)(logViewStateService, state => state.matches('checkingStatus') || state.matches('checkingStatusFailed') || state.matches('resolvedPersistedLogView') || state.matches('resolvedInlineLogView') ? state.context.resolvedLogView : undefined);
  const logViewStatus = (0, _react.useSelector)(logViewStateService, state => state.matches('resolvedPersistedLogView') || state.matches('resolvedInlineLogView') || state.matches('resolutionFailed') ? state.context.status : {
    index: 'unknown'
  });
  const isLoadingLogView = (0, _react.useSelector)(logViewStateService, state => state.matches('loading'));
  const isResolvingLogView = (0, _react.useSelector)(logViewStateService, state => state.matches('resolving'));
  const isLoadingLogViewStatus = (0, _react.useSelector)(logViewStateService, state => state.matches('checkingStatus'));
  const isUpdatingLogView = (0, _react.useSelector)(logViewStateService, state => state.matches('updating'));
  const isLoading = isLoadingLogView || isResolvingLogView || isLoadingLogViewStatus || isUpdatingLogView;
  const isUninitialized = (0, _react.useSelector)(logViewStateService, state => state.matches('uninitialized') || state.matches('initializingFromUrl'));
  const hasFailedLoadingLogView = (0, _react.useSelector)(logViewStateService, state => state.matches('loadingFailed'));
  const hasFailedResolvingLogView = (0, _react.useSelector)(logViewStateService, state => state.matches('resolutionFailed'));
  const hasFailedLoadingLogViewStatus = (0, _react.useSelector)(logViewStateService, state => state.matches('checkingStatusFailed'));
  const isPersistedLogView = (0, _react.useSelector)(logViewStateService, state => state.context.logViewReference.type === 'log-view-reference');
  const isInlineLogView = !isPersistedLogView;
  const latestLoadLogViewFailures = (0, _react.useSelector)(logViewStateService, state => state.matches('loadingFailed') || state.matches('resolutionFailed') || state.matches('checkingStatusFailed') ? [state.context.error] : []);
  const hasFailedLoading = latestLoadLogViewFailures.length > 0;
  const retry = (0, _react2.useCallback)(() => logViewStateService.send({
    type: 'RETRY'
  }), [logViewStateService]);
  const update = (0, _react2.useCallback)(async logViewAttributes => {
    logViewStateService.send({
      type: 'UPDATE',
      attributes: logViewAttributes
    });
    const doneState = await (0, _waitFor.waitFor)(logViewStateService, state => state.matches('updatingFailed') || state.matches('resolvedPersistedLogView') || state.matches('resolvedInlineLogView'));
    if (doneState.matches('updatingFailed')) {
      throw doneState.context.error;
    }
  }, [logViewStateService]);
  const revertToDefaultLogView = (0, _react2.useCallback)(() => {
    changeLogViewReference(_log_views.DEFAULT_LOG_VIEW);
  }, [changeLogViewReference]);
  return {
    // Underlying state machine
    logViewStateService,
    logViewStateNotifications,
    // Failure states
    hasFailedLoading,
    hasFailedLoadingLogView,
    hasFailedLoadingLogViewStatus,
    hasFailedResolvingLogView,
    latestLoadLogViewFailures,
    // Loading states
    isUninitialized,
    isLoading,
    isLoadingLogView,
    isLoadingLogViewStatus,
    isResolvingLogView,
    // Data
    logViewReference,
    logView,
    resolvedLogView,
    logViewStatus,
    derivedDataView: resolvedLogView === null || resolvedLogView === void 0 ? void 0 : resolvedLogView.dataViewReference,
    isInlineLogView,
    isPersistedLogView,
    // Actions
    load: retry,
    retry,
    update,
    changeLogViewReference,
    revertToDefaultLogView
  };
};
exports.useLogView = useLogView;
const [LogViewProvider, useLogViewContext] = (0, _constate.default)(useLogView);
exports.useLogViewContext = useLogViewContext;
exports.LogViewProvider = LogViewProvider;