"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useLogEntriesAfterResponse = exports.useLogEntriesAfterRequest = exports.useFetchLogEntriesAfter = exports.parseLogEntriesAfterSearchResponses = void 0;
var _react = require("react");
var _rxjs = require("rxjs");
var _runtime_types = require("../../../../common/runtime_types");
var _log_entries = require("../../../../common/search_strategies/log_entries/log_entries");
var _data_search = require("../../../utils/data_search");
var _use_observable = require("../../../utils/use_observable");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useLogEntriesAfterRequest = ({
  columnOverrides,
  endTimestamp,
  highlightPhrase,
  query,
  logViewReference,
  startTimestamp
}) => {
  const {
    search: fetchLogEntriesAfter,
    requests$: logEntriesAfterSearchRequests$
  } = (0, _data_search.useDataSearch)({
    getRequest: (0, _react.useCallback)((cursor, params) => {
      var _params$extendTo;
      return !!logViewReference ? {
        request: {
          params: _log_entries.logEntriesSearchRequestParamsRT.encode({
            after: cursor,
            columns: columnOverrides,
            endTimestamp: (_params$extendTo = params === null || params === void 0 ? void 0 : params.extendTo) !== null && _params$extendTo !== void 0 ? _params$extendTo : endTimestamp,
            highlightPhrase,
            query: query,
            size: params.size,
            logView: logViewReference,
            startTimestamp
          })
        },
        options: {
          strategy: _log_entries.LOG_ENTRIES_SEARCH_STRATEGY
        }
      } : null;
    }, [columnOverrides, endTimestamp, highlightPhrase, query, logViewReference, startTimestamp]),
    parseResponses: parseLogEntriesAfterSearchResponses
  });
  return {
    fetchLogEntriesAfter,
    logEntriesAfterSearchRequests$
  };
};
exports.useLogEntriesAfterRequest = useLogEntriesAfterRequest;
const useLogEntriesAfterResponse = logEntriesAfterSearchRequests$ => {
  const logEntriesAfterSearchResponse$ = (0, _use_observable.useOperator)(logEntriesAfterSearchRequests$, flattenLogEntriesAfterSearchResponse);
  const {
    cancelRequest,
    isRequestRunning,
    isResponsePartial,
    loaded,
    total
  } = (0, _data_search.useDataSearchResponseState)(logEntriesAfterSearchResponse$);
  return {
    cancelRequest,
    isRequestRunning,
    isResponsePartial,
    loaded,
    logEntriesAfterSearchRequests$,
    logEntriesAfterSearchResponse$,
    total
  };
};
exports.useLogEntriesAfterResponse = useLogEntriesAfterResponse;
const useFetchLogEntriesAfter = ({
  columnOverrides,
  endTimestamp,
  highlightPhrase,
  query,
  logViewReference,
  startTimestamp
}) => {
  const {
    fetchLogEntriesAfter,
    logEntriesAfterSearchRequests$
  } = useLogEntriesAfterRequest({
    columnOverrides,
    endTimestamp,
    highlightPhrase,
    query,
    logViewReference,
    startTimestamp
  });
  const {
    cancelRequest,
    isRequestRunning,
    isResponsePartial,
    loaded,
    logEntriesAfterSearchResponse$,
    total
  } = useLogEntriesAfterResponse(logEntriesAfterSearchRequests$);
  return {
    cancelRequest,
    fetchLogEntriesAfter,
    isRequestRunning,
    isResponsePartial,
    loaded,
    logEntriesAfterSearchResponse$,
    total
  };
};
exports.useFetchLogEntriesAfter = useFetchLogEntriesAfter;
const parseLogEntriesAfterSearchResponses = exports.parseLogEntriesAfterSearchResponses = (0, _data_search.normalizeDataSearchResponses)(null, (0, _runtime_types.decodeOrThrow)(_log_entries.logEntriesSearchResponsePayloadRT));
const flattenLogEntriesAfterSearchResponse = (0, _rxjs.exhaustMap)(_data_search.flattenDataSearchResponseDescriptor);