"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useLogHighlightsStateContext = exports.LogHighlightsStateProvider = void 0;
var _constate = _interopRequireDefault(require("constate"));
var _react = require("react");
var _useThrottle = _interopRequireDefault(require("react-use/lib/useThrottle"));
var _log_entry_highlights = require("./log_entry_highlights");
var _log_summary_highlights = require("./log_summary_highlights");
var _next_and_previous = require("./next_and_previous");
var _log_position = require("../log_position");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const FETCH_THROTTLE_INTERVAL = 3000;
const useLogHighlightsState = ({
  logViewReference,
  sourceVersion,
  centerCursor,
  size,
  filterQuery
}) => {
  const [highlightTerms, setHighlightTerms] = (0, _react.useState)([]);
  const {
    visibleMidpoint,
    jumpToTargetPosition,
    startTimestamp,
    endTimestamp
  } = (0, _log_position.useLogPositionStateContext)();
  const throttledStartTimestamp = (0, _useThrottle.default)(startTimestamp, FETCH_THROTTLE_INTERVAL);
  const throttledEndTimestamp = (0, _useThrottle.default)(endTimestamp, FETCH_THROTTLE_INTERVAL);
  const {
    logEntryHighlights,
    logEntryHighlightsById,
    loadLogEntryHighlightsRequest
  } = (0, _log_entry_highlights.useLogEntryHighlights)(logViewReference, sourceVersion, throttledStartTimestamp, throttledEndTimestamp, centerCursor, size, filterQuery, highlightTerms);
  const {
    logSummaryHighlights,
    loadLogSummaryHighlightsRequest
  } = (0, _log_summary_highlights.useLogSummaryHighlights)(logViewReference, sourceVersion, throttledStartTimestamp, throttledEndTimestamp, filterQuery, highlightTerms);
  const {
    currentHighlightKey,
    hasPreviousHighlight,
    hasNextHighlight,
    goToPreviousHighlight,
    goToNextHighlight
  } = (0, _next_and_previous.useNextAndPrevious)({
    visibleMidpoint,
    logEntryHighlights,
    highlightTerms,
    jumpToTargetPosition
  });
  return {
    highlightTerms,
    setHighlightTerms,
    logEntryHighlights,
    logEntryHighlightsById,
    logSummaryHighlights,
    loadLogEntryHighlightsRequest,
    loadLogSummaryHighlightsRequest,
    currentHighlightKey,
    hasPreviousHighlight,
    hasNextHighlight,
    goToPreviousHighlight,
    goToNextHighlight
  };
};
const [LogHighlightsStateProvider, useLogHighlightsStateContext] = (0, _constate.default)(useLogHighlightsState);
exports.useLogHighlightsStateContext = useLogHighlightsStateContext;
exports.LogHighlightsStateProvider = LogHighlightsStateProvider;