"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LogDateRow = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _datetime = require("../../../../common/formatters/datetime");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Show a row with the date in the log stream
 */
const LogDateRow = ({
  time
}) => {
  const formattedDate = (0, _datetime.localizedDate)(new Date(time));
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xxs"
  }, /*#__PURE__*/_react.default.createElement("h2", {
    style: {
      paddingLeft: 8
    }
  }, formattedDate))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    "aria-hidden": "true"
  })));
};
exports.LogDateRow = LogDateRow;