"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getTraceQuery = exports.getTimeRangeStartFromTime = exports.getTimeRangeEndFromTime = exports.getNodeQuery = exports.getLogsQuery = exports.createNodeLogsQuery = void 0;
var _moment = _interopRequireDefault(require("moment"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getLogsQuery = params => {
  const {
    filter
  } = params;
  return filter ? {
    language: 'kuery',
    query: filter
  } : undefined;
};
exports.getLogsQuery = getLogsQuery;
const createNodeLogsQuery = params => {
  const {
    nodeField,
    nodeId,
    filter
  } = params;
  const nodeFilter = `${nodeField}: ${nodeId}`;
  return filter ? `(${nodeFilter}) and (${filter})` : nodeFilter;
};
exports.createNodeLogsQuery = createNodeLogsQuery;
const getNodeQuery = params => {
  return {
    language: 'kuery',
    query: createNodeLogsQuery(params)
  };
};
exports.getNodeQuery = getNodeQuery;
const getTraceQuery = params => {
  const {
    traceId,
    filter
  } = params;
  const traceFilter = `trace.id:"${traceId}" OR (not trace.id:* AND "${traceId}")`;
  const query = filter ? `(${traceFilter}) and (${filter})` : traceFilter;
  return {
    language: 'kuery',
    query
  };
};
exports.getTraceQuery = getTraceQuery;
const defaultTimeRangeFromPositionOffset = {
  hours: 1
};
const getTimeRangeStartFromTime = time => (0, _moment.default)(time).subtract(defaultTimeRangeFromPositionOffset).toISOString();
exports.getTimeRangeStartFromTime = getTimeRangeStartFromTime;
const getTimeRangeEndFromTime = time => (0, _moment.default)(time).add(defaultTimeRangeFromPositionOffset).toISOString();
exports.getTimeRangeEndFromTime = getTimeRangeEndFromTime;