"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.updateTimefilterFromContext = exports.updateContextFromTimefilter = exports.subscribeToTimefilterService = void 0;
var _rxjs = require("rxjs");
var _xstate = require("xstate");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const subscribeToTimefilterService = query => () => {
  const {
    timefilter: {
      timefilter
    }
  } = query;
  const time$ = timefilter.getTimeUpdate$().pipe((0, _rxjs.map)(() => ({
    type: 'RECEIVE_TIMEFILTER_TIME',
    time: timefilter.getTime()
  })));
  const refreshInterval$ = timefilter.getRefreshIntervalUpdate$().pipe((0, _rxjs.map)(() => ({
    type: 'RECEIVE_TIMEFILTER_REFRESH_INTERVAL',
    refreshInterval: timefilter.getRefreshInterval()
  })));
  return (0, _rxjs.merge)(time$, refreshInterval$);
};
exports.subscribeToTimefilterService = subscribeToTimefilterService;
const updateContextFromTimefilter = exports.updateContextFromTimefilter = _xstate.actions.assign((context, event) => {
  if (event.type === 'RECEIVE_TIMEFILTER_TIME' && 'time' in event) {
    return {
      time: event.time
    };
  }
  if (event.type === 'RECEIVE_TIMEFILTER_REFRESH_INTERVAL' && 'refreshInterval' in event) {
    return {
      refreshInterval: event.refreshInterval
    };
  }
  return {};
});
const updateTimefilterFromContext = query => (context, _event) => {
  if (context.time != null) {
    query.timefilter.timefilter.setTime(context.time);
  }
  if (context.refreshInterval != null) {
    query.timefilter.timefilter.setRefreshInterval(context.refreshInterval);
  }
};
exports.updateTimefilterFromContext = updateTimefilterFromContext;