"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createDataReceivedEventEmitter = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const createDataReceivedEventEmitter = publicEvents$ => {
  return (context, event) => {
    var _event$dataState;
    if (event.type === 'RECEIVE_DISCOVER_DATA_STATE' && 'dataState' in event && ((_event$dataState = event.dataState) === null || _event$dataState === void 0 ? void 0 : _event$dataState.length) !== undefined && event.dataState.length > 0) {
      publicEvents$.next({
        type: 'LOGS_EXPLORER_DATA_RECEIVED',
        payload: {
          rowCount: event.dataState.length
        }
      });
    }
  };
};
exports.createDataReceivedEventEmitter = createDataReceivedEventEmitter;