"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useDatasetsContext = exports.DatasetsProvider = void 0;
var _react = require("react");
var _constate = _interopRequireDefault(require("constate"));
var _react2 = require("@xstate/react");
var _datasets = require("../state_machines/datasets");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useDatasets = ({
  datasetsClient
}) => {
  const datasetsStateService = (0, _react2.useInterpret)(() => (0, _datasets.createDatasetsStateMachine)({
    datasetsClient
  }));
  const datasets = (0, _react2.useSelector)(datasetsStateService, state => state.context.datasets);
  const error = (0, _react2.useSelector)(datasetsStateService, state => state.context.error);
  const isLoading = (0, _react2.useSelector)(datasetsStateService, state => state.matches('loading') || state.matches('debounceSearchingDatasets'));
  const loadDatasets = (0, _react.useCallback)(() => datasetsStateService.send({
    type: 'LOAD_DATASETS'
  }), [datasetsStateService]);
  const reloadDatasets = (0, _react.useCallback)(() => datasetsStateService.send({
    type: 'RELOAD_DATASETS'
  }), [datasetsStateService]);
  const searchDatasets = (0, _react.useCallback)(searchParams => datasetsStateService.send({
    type: 'SEARCH_DATASETS',
    search: formatSearchParams(searchParams)
  }), [datasetsStateService]);
  const sortDatasets = (0, _react.useCallback)(searchParams => datasetsStateService.send({
    type: 'SORT_DATASETS',
    search: formatSearchParams(searchParams)
  }), [datasetsStateService]);
  return {
    // Underlying state machine
    datasetsStateService,
    // Failure states
    error,
    // Loading states
    isLoading,
    // Data
    datasets,
    // Actions
    loadDatasets,
    reloadDatasets,
    searchDatasets,
    sortDatasets
  };
};
const [DatasetsProvider, useDatasetsContext] = (0, _constate.default)(useDatasets);

/**
 * Utils
 */
exports.useDatasetsContext = useDatasetsContext;
exports.DatasetsProvider = DatasetsProvider;
const formatSearchParams = ({
  name,
  ...params
}) => ({
  datasetQuery: name,
  ...params
});