"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useDataSourceSelection = void 0;
var _react = require("@xstate/react");
var _react2 = require("react");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useDataSourceSelection = logsExplorerControllerStateService => {
  const dataSourceSelection = (0, _react.useSelector)(logsExplorerControllerStateService, state => {
    return state.context.dataSourceSelection;
  });
  const allSelection = (0, _react.useSelector)(logsExplorerControllerStateService, state => {
    return state.context.allSelection;
  });
  const handleDataSourceSelectionChange = (0, _react2.useCallback)(data => {
    logsExplorerControllerStateService.send({
      type: 'UPDATE_DATA_SOURCE_SELECTION',
      data
    });
  }, [logsExplorerControllerStateService]);
  return {
    dataSourceSelection,
    allSelection,
    handleDataSourceSelectionChange
  };
};
exports.useDataSourceSelection = useDataSourceSelection;