"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.CustomDataSourceSelector = void 0;
var _react = _interopRequireDefault(require("react"));
var _data_source_selector = require("../components/data_source_selector");
var _use_datasets = require("../hooks/use_datasets");
var _use_data_source_selection = require("../hooks/use_data_source_selection");
var _use_data_views = require("../hooks/use_data_views");
var _use_esql = require("../hooks/use_esql");
var _use_integrations = require("../hooks/use_integrations");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const CustomDataSourceSelector = exports.CustomDataSourceSelector = withProviders(({
  logsExplorerControllerStateService
}) => {
  const {
    dataSourceSelection,
    handleDataSourceSelectionChange,
    allSelection
  } = (0, _use_data_source_selection.useDataSourceSelection)(logsExplorerControllerStateService);
  const {
    error: integrationsError,
    integrations,
    isLoading: isLoadingIntegrations,
    isSearching: isSearchingIntegrations,
    loadMore,
    reloadIntegrations,
    searchIntegrations,
    searchIntegrationsStreams,
    sortIntegrations,
    sortIntegrationsStreams
  } = (0, _use_integrations.useIntegrationsContext)();
  const {
    datasets,
    error: datasetsError,
    isLoading: isLoadingUncategorized,
    loadDatasets,
    reloadDatasets,
    searchDatasets,
    sortDatasets
  } = (0, _use_datasets.useDatasetsContext)();
  const {
    dataViews,
    dataViewCount,
    error: dataViewsError,
    isLoading: isLoadingDataViews,
    isDataViewAllowed,
    isDataViewAvailable,
    loadDataViews,
    reloadDataViews,
    searchDataViews,
    filterDataViews,
    sortDataViews
  } = (0, _use_data_views.useDataViewsContext)();
  const {
    isEsqlEnabled,
    discoverEsqlUrlProps
  } = (0, _use_esql.useEsql)({
    dataSourceSelection
  });
  return /*#__PURE__*/_react.default.createElement(_data_source_selector.DataSourceSelector, {
    datasets: datasets,
    dataSourceSelection: dataSourceSelection,
    allSelection: allSelection,
    datasetsError: datasetsError,
    dataViews: dataViews,
    dataViewCount: dataViewCount,
    dataViewsError: dataViewsError,
    discoverEsqlUrlProps: discoverEsqlUrlProps,
    isDataViewAllowed: isDataViewAllowed,
    isDataViewAvailable: isDataViewAvailable,
    integrations: integrations,
    integrationsError: integrationsError,
    isEsqlEnabled: isEsqlEnabled,
    isLoadingDataViews: isLoadingDataViews,
    isLoadingIntegrations: isLoadingIntegrations,
    isLoadingUncategorized: isLoadingUncategorized,
    isSearchingIntegrations: isSearchingIntegrations,
    onDataViewsReload: reloadDataViews,
    onDataViewsSearch: searchDataViews,
    onDataViewsFilter: filterDataViews,
    onDataViewsSort: sortDataViews,
    onDataViewsTabClick: loadDataViews,
    onIntegrationsLoadMore: loadMore,
    onIntegrationsReload: reloadIntegrations,
    onIntegrationsSearch: searchIntegrations,
    onIntegrationsSort: sortIntegrations,
    onIntegrationsStreamsSearch: searchIntegrationsStreams,
    onIntegrationsStreamsSort: sortIntegrationsStreams,
    onSelectionChange: handleDataSourceSelectionChange,
    onUncategorizedReload: reloadDatasets,
    onUncategorizedSearch: searchDatasets,
    onUncategorizedSort: sortDatasets,
    onUncategorizedTabClick: loadDatasets
  });
});

// eslint-disable-next-line import/no-default-export
var _default = exports.default = CustomDataSourceSelector;
function withProviders(Component) {
  return function ComponentWithProviders({
    controller,
    core,
    datasetsClient,
    dataViews,
    logsExplorerControllerStateService
  }) {
    var _controller$customiza;
    return /*#__PURE__*/_react.default.createElement(_use_integrations.IntegrationsProvider, {
      datasetsClient: datasetsClient
    }, /*#__PURE__*/_react.default.createElement(_use_datasets.DatasetsProvider, {
      datasetsClient: datasetsClient
    }, /*#__PURE__*/_react.default.createElement(_use_data_views.DataViewsProvider, {
      core: core,
      dataViewsService: dataViews,
      events: (_controller$customiza = controller.customizations) === null || _controller$customiza === void 0 ? void 0 : _controller$customiza.events
    }, /*#__PURE__*/_react.default.createElement(Component, {
      logsExplorerControllerStateService: logsExplorerControllerStateService
    }))));
  };
}