"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createMemoryUrlStateStorage = exports.createDiscoverMemoryHistory = void 0;
var _public = require("@kbn/kibana-utils-plugin/public");
var _history = require("history");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Create a MemoryHistory instance. It is initialized with an application state
 * object, because Discover radically resets too much when the URL is "empty".
 */
const createDiscoverMemoryHistory = () => (0, _history.createMemoryHistory)({
  initialEntries: [{
    search: `?_a=()`
  }]
});

/**
 * Create a url state storage that's not connected to the real browser location
 * to isolate the Discover component from these side-effects.
 */
exports.createDiscoverMemoryHistory = createDiscoverMemoryHistory;
const createMemoryUrlStateStorage = memoryHistory => (0, _public.createKbnUrlStateStorage)({
  history: memoryHistory,
  useHash: false,
  useHashQuery: false
});
exports.createMemoryUrlStateStorage = createMemoryUrlStateStorage;