"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.ListStatus = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _constants = require("../constants");
var _datasets_skeleton = require("./datasets_skeleton");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ListStatus = ({
  data,
  description,
  error,
  isLoading,
  onRetry,
  title
}) => {
  const isEmpty = data == null || data.length <= 0;
  const hasError = error !== null;
  if (isLoading) {
    return /*#__PURE__*/_react.default.createElement(_datasets_skeleton.DatasetSkeleton, null);
  }
  if (hasError) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
      "data-test-subj": "dataSourceSelectorListStatusErrorPrompt",
      iconType: "warning",
      iconColor: "danger",
      paddingSize: "m",
      title: /*#__PURE__*/_react.default.createElement("h2", null, title),
      titleSize: "s",
      body: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.logsExplorer.dataSourceSelector.noDataError",
        defaultMessage: "An {error} occurred while getting your data. Please retry.",
        values: {
          error: /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
            content: error.message
          }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
            color: "danger"
          }, _constants.errorLabel))
        }
      }),
      actions: [/*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
        "data-test-subj": "logsExplorerListStatusButton",
        onClick: onRetry
      }, _constants.noDataRetryLabel)]
    });
  }
  if (isEmpty) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
      "data-test-subj": "dataSourceSelectorListStatusEmptyPrompt",
      iconType: "search",
      paddingSize: "m",
      title: /*#__PURE__*/_react.default.createElement("h2", null, title),
      titleSize: "s",
      body: /*#__PURE__*/_react.default.createElement("p", null, description)
    });
  }
  return null;
};

// eslint-disable-next-line import/no-default-export
exports.ListStatus = ListStatus;
var _default = exports.default = ListStatus;