"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.readListRoute = void 0;
var _securitysolutionEsUtils = require("@kbn/securitysolution-es-utils");
var _securitysolutionListConstants = require("@kbn/securitysolution-list-constants");
var _zodHelpers = require("@kbn/zod-helpers");
var _api = require("@kbn/securitysolution-lists-common/api");
var _utils = require("../utils");
var _ = require("..");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const readListRoute = router => {
  router.versioned.get({
    access: 'public',
    path: _securitysolutionListConstants.LIST_URL,
    security: {
      authz: {
        requiredPrivileges: ['lists-read']
      }
    }
  }).addVersion({
    validate: {
      request: {
        query: (0, _zodHelpers.buildRouteValidationWithZod)(_api.ReadListRequestQuery)
      }
    },
    version: '2023-10-31'
  }, async (context, request, response) => {
    const siemResponse = (0, _utils.buildSiemResponse)(response);
    try {
      const {
        id
      } = request.query;
      const lists = await (0, _.getListClient)(context);
      const list = await lists.getList({
        id
      });
      if (list == null) {
        return siemResponse.error({
          body: `list id: "${id}" does not exist`,
          statusCode: 404
        });
      }
      return response.ok({
        body: _api.ReadListResponse.parse(list)
      });
    } catch (err) {
      const error = (0, _securitysolutionEsUtils.transformError)(err);
      return siemResponse.error({
        body: error.message,
        statusCode: error.statusCode
      });
    }
  });
};
exports.readListRoute = readListRoute;