"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LinkOptionsComponent = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _public = require("@kbn/presentation-util-plugin/public");
var _public2 = require("@kbn/ui-actions-enhanced-plugin/public");
var _content_management = require("../../../common/content_management");
var _links_strings = require("../links_strings");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const LinkOptionsComponent = ({
  link,
  setLinkOptions,
  selectedLinkType
}) => {
  const [dashboardLinkOptions, setDashboardLinkOptions] = (0, _react.useState)({
    ..._public.DEFAULT_DASHBOARD_DRILLDOWN_OPTIONS,
    ...(link && link.type === _content_management.DASHBOARD_LINK_TYPE ? link.options : {})
  });
  const [externalLinkOptions, setExternalLinkOptions] = (0, _react.useState)({
    ..._public2.DEFAULT_URL_DRILLDOWN_OPTIONS,
    ...(link && link.type === _content_management.EXTERNAL_LINK_TYPE ? link.options : {})
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _links_strings.LinksStrings.editor.linkEditor.getLinkOptionsLabel()
  }, selectedLinkType === _content_management.DASHBOARD_LINK_TYPE ? /*#__PURE__*/_react.default.createElement(_public.DashboardDrilldownOptionsComponent, {
    options: dashboardLinkOptions,
    onOptionChange: change => {
      setDashboardLinkOptions({
        ...dashboardLinkOptions,
        ...change
      });
      setLinkOptions({
        ...dashboardLinkOptions,
        ...change
      });
    }
  }) : /*#__PURE__*/_react.default.createElement(_public2.UrlDrilldownOptionsComponent, {
    options: externalLinkOptions,
    onOptionChange: change => {
      setExternalLinkOptions({
        ...externalLinkOptions,
        ...change
      });
      setLinkOptions({
        ...externalLinkOptions,
        ...change
      });
    }
  }));
};
exports.LinkOptionsComponent = LinkOptionsComponent;