"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getLegendStatsTelemetryEvents = void 0;
var _lodash = require("lodash");
var _utils = require("../../utils");
var _legend_settings_popover = require("../../shared_components/legend/legend_settings_popover");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const LEGEND_STATS_PREFIX = 'legend_stats';
const constructName = eventName => `${LEGEND_STATS_PREFIX}${eventName}`;
const getLegendStatsTelemetryEvents = (legendStats, prevLegendStats) => {
  if (!legendStats || !legendStats.length || (0, _lodash.isEqual)(legendStats, prevLegendStats)) {
    return [];
  }
  if (!(0, _legend_settings_popover.shouldDisplayTable)(legendStats)) {
    return [];
  }
  const mainEvent = LEGEND_STATS_PREFIX;
  const typesEvents = legendStats.map(legendStat => {
    return constructName(`_${legendStat}`);
  });
  const counterText = getRangeText(legendStats.length);
  const counterEvent = counterText ? constructName(counterText) : undefined;
  return [mainEvent, ...typesEvents, counterEvent].filter(_utils.nonNullable);
};
exports.getLegendStatsTelemetryEvents = getLegendStatsTelemetryEvents;
function getRangeText(n) {
  if (n < 1) {
    return;
  }
  if (n < 4) {
    return `_amount_${String(n)}`;
  }
  if (n >= 4 && n <= 7) {
    return '_amount_4_to_7';
  }
  if (n >= 8) {
    return '_amount_above_8';
  }
}