"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AddLayerButton = AddLayerButton;
exports.AddLayerPanelType = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/expression-xy-plugin/public");
var _react2 = require("@emotion/react");
var _load_annotation_library_flyout = require("./load_annotation_library_flyout");
var _types = require("./types");
var _state_helpers = require("./state_helpers");
var _visualization_helpers = require("./visualization_helpers");
var _shared_components = require("../../shared_components");
var _chart_option = require("../../editor_frame_service/editor_frame/config_panel/chart_switch/chart_option");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
let AddLayerPanelType = exports.AddLayerPanelType = /*#__PURE__*/function (AddLayerPanelType) {
  AddLayerPanelType["main"] = "main";
  AddLayerPanelType["selectAnnotationMethod"] = "selectAnnotationMethod";
  AddLayerPanelType["compatibleVisualizationTypes"] = "compatibleVisualizationTypes";
  return AddLayerPanelType;
}({});
function AddLayerButton({
  state,
  supportedLayers,
  addLayer,
  eventAnnotationService,
  isInlineEditing
}) {
  var _getDataLayers2, _getDataLayers2$;
  const [showLayersChoice, toggleLayersChoice] = (0, _react.useState)(false);
  const [isLoadLibraryVisible, setLoadLibraryFlyoutVisible] = (0, _react.useState)(false);
  const annotationPanel = ({
    type,
    label,
    icon,
    disabled,
    toolTipContent
  }) => {
    return {
      panel: AddLayerPanelType.selectAnnotationMethod,
      toolTipContent,
      disabled,
      name: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        gutterSize: "s",
        responsive: false,
        alignItems: "center"
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: true
      }, label), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false
      }, /*#__PURE__*/_react.default.createElement(_shared_components.ExperimentalBadge, {
        color: disabled ? 'subdued' : undefined,
        size: "m"
      }))),
      icon: icon && /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
        size: "m",
        type: icon
      }),
      ['data-test-subj']: `lnsLayerAddButton-${type}`
    };
  };
  const dataPanel = ({
    type,
    label,
    icon,
    disabled,
    toolTipContent
  }) => {
    return {
      panel: AddLayerPanelType.compatibleVisualizationTypes,
      toolTipContent,
      disabled,
      name: label,
      icon: icon && /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
        size: "m",
        type: icon
      }),
      ['data-test-subj']: `lnsLayerAddButton-${type}`
    };
  };
  const horizontalOnly = (0, _state_helpers.isHorizontalChart)(state.layers);
  const availableVisTypes = _types.visualizationTypes.filter(t => (0, _state_helpers.isHorizontalSeries)(t.id) === horizontalOnly);
  const currentLayerTypeIndex = availableVisTypes.findIndex(t => {
    var _getDataLayers, _getDataLayers$;
    return t.id === ((_getDataLayers = (0, _visualization_helpers.getDataLayers)(state.layers)) === null || _getDataLayers === void 0 ? void 0 : (_getDataLayers$ = _getDataLayers[0]) === null || _getDataLayers$ === void 0 ? void 0 : _getDataLayers$.seriesType);
  }) || 0;
  const firstLayerSubtype = (_getDataLayers2 = (0, _visualization_helpers.getDataLayers)(state.layers)) === null || _getDataLayers2 === void 0 ? void 0 : (_getDataLayers2$ = _getDataLayers2[0]) === null || _getDataLayers2$ === void 0 ? void 0 : _getDataLayers2$.seriesType;
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    display: "block",
    "data-test-subj": "lnsConfigPanel__addLayerPopover",
    button: /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      fullWidth: true,
      "data-test-subj": "lnsLayerAddButton",
      "aria-label": _i18n.i18n.translate('xpack.lens.configPanel.addLayerButton', {
        defaultMessage: 'Add layer'
      }),
      fill: false,
      color: "primary",
      size: "s",
      onClick: () => toggleLayersChoice(!showLayersChoice),
      iconType: "layers"
    }, _i18n.i18n.translate('xpack.lens.configPanel.addLayerButton', {
      defaultMessage: 'Add layer'
    })),
    isOpen: showLayersChoice,
    closePopover: () => toggleLayersChoice(false),
    panelPaddingSize: "none"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenu, {
    initialPanelId: AddLayerPanelType.main,
    size: "s",
    panels: [{
      id: AddLayerPanelType.main,
      title: _i18n.i18n.translate('xpack.lens.configPanel.selectLayerType', {
        defaultMessage: 'Select layer type'
      }),
      width: 300,
      items: supportedLayers.map(props => {
        const {
          type,
          label,
          icon,
          disabled,
          toolTipContent
        } = props;
        if (type === _public.LayerTypes.ANNOTATIONS) {
          return annotationPanel(props);
        } else if (type === _public.LayerTypes.DATA) {
          if (horizontalOnly) {
            return {
              toolTipContent,
              disabled,
              name: label,
              icon: icon && /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
                size: "m",
                type: icon
              }),
              ['data-test-subj']: `lnsLayerAddButton-${type}`,
              onClick: () => {
                addLayer(type);
                toggleLayersChoice(false);
              }
            };
          }
          return dataPanel(props);
        }
        return {
          toolTipContent,
          disabled,
          name: label,
          icon: icon && /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
            size: "m",
            type: icon
          }),
          ['data-test-subj']: `lnsLayerAddButton-${type}`,
          onClick: () => {
            addLayer(type);
            toggleLayersChoice(false);
          }
        };
      })
    }, {
      id: AddLayerPanelType.selectAnnotationMethod,
      initialFocusedItemIndex: 0,
      title: _i18n.i18n.translate('xpack.lens.configPanel.selectAnnotationMethod', {
        defaultMessage: 'Select annotation method'
      }),
      items: [{
        name: _i18n.i18n.translate('xpack.lens.configPanel.newAnnotation', {
          defaultMessage: 'New annotation'
        }),
        icon: 'plusInCircle',
        onClick: () => {
          addLayer(_public.LayerTypes.ANNOTATIONS);
          toggleLayersChoice(false);
        },
        'data-test-subj': 'lnsAnnotationLayer_new'
      }, {
        name: _i18n.i18n.translate('xpack.lens.configPanel.loadFromLibrary', {
          defaultMessage: 'Load from library'
        }),
        icon: 'folderOpen',
        onClick: () => {
          setLoadLibraryFlyoutVisible(true);
          toggleLayersChoice(false);
        },
        'data-test-subj': 'lnsAnnotationLayer_addFromLibrary'
      }]
    }, {
      id: AddLayerPanelType.compatibleVisualizationTypes,
      initialFocusedItemIndex: currentLayerTypeIndex,
      title: _i18n.i18n.translate('xpack.lens.layerPanel.compatibleVisualizationTypes', {
        defaultMessage: 'Compatible visualization types'
      }),
      width: 340,
      items: availableVisTypes.map(t => {
        var _t$subtypes;
        const canInitializeWithSubtype = ((_t$subtypes = t.subtypes) === null || _t$subtypes === void 0 ? void 0 : _t$subtypes.includes(firstLayerSubtype)) && !(0, _state_helpers.isPercentageSeries)(firstLayerSubtype);
        return {
          renderItem: () => {
            return /*#__PURE__*/_react.default.createElement(ChartOptionWrapper, {
              type: t.id,
              label: t.label,
              description: t.description,
              icon: t.icon,
              onClick: () => {
                var _t$subtypes2;
                addLayer(_public.LayerTypes.DATA, undefined, undefined, canInitializeWithSubtype ? firstLayerSubtype : (_t$subtypes2 = t.subtypes) === null || _t$subtypes2 === void 0 ? void 0 : _t$subtypes2[0]);
                toggleLayersChoice(false);
              }
            });
          }
        };
      })
    }]
  })), isLoadLibraryVisible && /*#__PURE__*/_react.default.createElement(_load_annotation_library_flyout.LoadAnnotationLibraryFlyout, {
    isLoadLibraryVisible: isLoadLibraryVisible,
    setLoadLibraryFlyoutVisible: setLoadLibraryFlyoutVisible,
    eventAnnotationService: eventAnnotationService,
    isInlineEditing: isInlineEditing,
    addLayer: extraArg => {
      addLayer(_public.LayerTypes.ANNOTATIONS, extraArg);
    }
  }));
}
const ChartOptionWrapper = ({
  label,
  description,
  icon,
  onClick,
  type
}) => {
  const euiThemeContext = (0, _eui.useEuiTheme)();
  return /*#__PURE__*/_react.default.createElement("button", {
    "data-test-subj": `lnsXY_seriesType-${type}`,
    onClick: onClick,
    className: "euiContextMenuItem",
    css: chartOptionWrapperStyles(euiThemeContext)
  }, /*#__PURE__*/_react.default.createElement(_chart_option.ChartOption, {
    option: {
      icon,
      label,
      description
    }
  }));
};
const chartOptionWrapperStyles = ({
  euiTheme
}) => (0, _react2.css)`
  padding: ${euiTheme.size.s};
  border-bottom: ${euiTheme.border.thin};
  border-bottom-color: ${euiTheme.colors.backgroundBaseSubdued};
  width: 100%;
  &:hover,
  &:focus {
    color: ${euiTheme.colors.primary};
    background-color: ${euiTheme.colors.backgroundBasePrimary};
    span,
    .euiText {
      text-decoration: underline;
      color: ${euiTheme.colors.primary};
    }
  }
`;