"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.execute = execute;
exports.getHref = getHref;
exports.getLocation = getLocation;
exports.isCompatible = isCompatible;
var _type_guards = require("../react_embeddable/type_guards");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function isCompatible({
  hasDiscoverAccess,
  embeddable
}) {
  if (!hasDiscoverAccess) return false;
  try {
    return (0, _type_guards.isLensApi)(embeddable) && embeddable.canViewUnderlyingData$.getValue();
  } catch (e) {
    // Fetching underlying data failed, log the error and behave as if the action is not compatible
    // eslint-disable-next-line no-console
    console.error(e);
    return false;
  }
}
async function getDiscoverLocationParams({
  embeddable,
  filters,
  dataViews,
  timeFieldName
}) {
  if (!(0, _type_guards.isLensApi)(embeddable)) {
    // shouldn't be executed because of the isCompatible check
    throw new Error('Can only be executed in the context of Lens visualization');
  }
  const args = embeddable.getViewUnderlyingDataArgs();
  if (!args) {
    // shouldn't be executed because of the isCompatible check
    throw new Error('Underlying data is not ready');
  }
  const dataView = await dataViews.get(args.dataViewSpec.id);
  // we don't want to pass the DSL filters when navigating from an ES|SQL embeddable
  let filtersToApply = embeddable.isTextBasedLanguage() ? [] : [...(filters || []), ...args.filters];
  let timeRangeToApply = args.timeRange;
  // if the target data view is time based, attempt to split out a time range from the provided filters
  if (dataView.isTimeBased() && dataView.timeFieldName === timeFieldName) {
    const {
      extractTimeRange
    } = await Promise.resolve().then(() => _interopRequireWildcard(require('@kbn/es-query')));
    const {
      restOfFilters,
      timeRange
    } = extractTimeRange(filters || [], timeFieldName);
    filtersToApply = restOfFilters;
    if (timeRange) {
      timeRangeToApply = timeRange;
    }
  }
  return {
    ...args,
    timeRange: timeRangeToApply,
    filters: filtersToApply
  };
}
async function getHref({
  embeddable,
  locator,
  filters,
  dataViews,
  timeFieldName
}) {
  const params = await getDiscoverLocationParams({
    embeddable,
    filters,
    dataViews,
    timeFieldName
  });
  const discoverUrl = locator === null || locator === void 0 ? void 0 : locator.getRedirectUrl(params);
  return discoverUrl;
}
async function getLocation({
  embeddable,
  locator,
  filters,
  dataViews,
  timeFieldName
}) {
  const params = await getDiscoverLocationParams({
    embeddable,
    filters,
    dataViews,
    timeFieldName
  });
  const discoverLocation = locator === null || locator === void 0 ? void 0 : locator.getLocation(params);
  if (!discoverLocation) {
    throw new Error('Discover location not found');
  }
  return discoverLocation;
}
async function execute({
  embeddable,
  locator,
  filters,
  openInSameTab,
  dataViews,
  timeFieldName,
  hasDiscoverAccess
}) {
  const discoverUrl = await getHref({
    embeddable,
    locator,
    filters,
    dataViews,
    timeFieldName,
    hasDiscoverAccess
  });
  window.open(discoverUrl, !openInSameTab ? '_blank' : '_self');
}