"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getDiscoverHelpersAsync = exports.createOpenInDiscoverAction = void 0;
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/ui-actions-plugin/public");
var _rxjs = require("rxjs");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const ACTION_OPEN_IN_DISCOVER = 'ACTION_OPEN_IN_DISCOVER';
const getDiscoverHelpersAsync = async () => await Promise.resolve().then(() => _interopRequireWildcard(require('../async_services')));
exports.getDiscoverHelpersAsync = getDiscoverHelpersAsync;
const createOpenInDiscoverAction = (locator, dataViews, hasDiscoverAccess) => {
  const actionDefinition = {
    type: ACTION_OPEN_IN_DISCOVER,
    id: ACTION_OPEN_IN_DISCOVER,
    order: 20,
    // right before Inspect which is 19
    getIconType: () => 'discoverApp',
    getDisplayName: () => _i18n.i18n.translate('xpack.lens.action.exploreInDiscover', {
      defaultMessage: 'Explore in Discover'
    }),
    getHref: async context => {
      const {
        getHref
      } = await getDiscoverHelpersAsync();
      return getHref({
        locator,
        dataViews,
        hasDiscoverAccess,
        ...context
      });
    },
    isCompatible: async context => {
      const {
        isCompatible
      } = await getDiscoverHelpersAsync();
      return await isCompatible({
        hasDiscoverAccess,
        locator,
        dataViews,
        embeddable: context.embeddable
      });
    },
    couldBecomeCompatible: ({
      embeddable
    }) => {
      if (!typeof embeddable.canViewUnderlyingData$) throw new _public.IncompatibleActionError();
      return hasDiscoverAccess && Boolean(embeddable.canViewUnderlyingData$);
    },
    getCompatibilityChangesSubject: ({
      embeddable
    }) => {
      if (!typeof embeddable.canViewUnderlyingData$) return;
      return embeddable.canViewUnderlyingData$.pipe((0, _rxjs.map)(() => undefined));
    },
    execute: async context => {
      const {
        execute
      } = await getDiscoverHelpersAsync();
      return execute({
        ...context,
        locator,
        dataViews,
        hasDiscoverAccess
      });
    }
  };
  return (0, _public.createAction)(actionDefinition);
};
exports.createOpenInDiscoverAction = createOpenInDiscoverAction;