"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.setupPanelManagement = setupPanelManagement;
var _presentationContainers = require("@kbn/presentation-containers");
var _rxjs = require("rxjs");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function setupPanelManagement(uuid, parentApi, {
  isNewlyCreated$,
  setAsCreated
}) {
  const isEditing$ = new _rxjs.BehaviorSubject(false);
  return {
    isEditingEnabled: () => true,
    isNewPanel: () => isNewlyCreated$.getValue(),
    onStopEditing: (isCancel = false, state) => {
      isEditing$.next(false);
      if (isNewlyCreated$.getValue() && isCancel && !state) {
        if ((0, _presentationContainers.apiIsPresentationContainer)(parentApi)) {
          parentApi === null || parentApi === void 0 ? void 0 : parentApi.removePanel(uuid);
        }
      }
      setAsCreated();
    }
  };
}