"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.prepareCallbacks = prepareCallbacks;
var _presentationPublishing = require("@kbn/presentation-publishing");
var _on_render = require("./on_render");
var _on_event = require("./on_event");
var _logger = require("../logger");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function prepareCallbacks(api, internalApi, parentApi, getState, services, executionContext, onDataUpdate, dispatchRenderComplete, callbacks) {
  const disableTriggers = (0, _presentationPublishing.apiHasDisableTriggers)(parentApi) ? parentApi.disableTriggers : undefined;
  return {
    disableTriggers,
    onRender: (0, _on_render.prepareOnRender)(api, internalApi, parentApi, getState, services, executionContext, dispatchRenderComplete),
    onData: (_data, adapters) => {
      (0, _logger.addLog)(`onData$`);
      onDataUpdate(adapters);
    },
    handleEvent: (0, _on_event.prepareEventHandler)(api, getState, callbacks, services, disableTriggers)
  };
}