"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.suggestionsApi = void 0;
var _visualizationUtils = require("@kbn/visualization-utils");
var _suggestion_helpers = require("../editor_frame_service/editor_frame/suggestion_helpers");
var _helpers = require("./helpers");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const suggestionsApi = ({
  context,
  dataView,
  datasourceMap,
  visualizationMap,
  excludedVisualizations,
  preferredChartType,
  preferredVisAttributes
}) => {
  const initialContext = context;
  if (!datasourceMap || !visualizationMap || !dataView.id) return undefined;
  const datasourceStates = {
    formBased: {
      isLoading: false,
      state: {
        layers: {}
      }
    },
    textBased: {
      isLoading: false,
      state: {
        layers: {},
        indexPatternRefs: [],
        initialContext
      }
    }
  };
  const currentDataViewId = dataView.id;
  const dataViews = {
    indexPatterns: {
      [currentDataViewId]: dataView
    },
    indexPatternRefs: []
  };
  const initialVisualization = (visualizationMap === null || visualizationMap === void 0 ? void 0 : visualizationMap[Object.keys(visualizationMap)[0]]) || null;

  // find the active visualizations from the context
  const suggestions = (0, _suggestion_helpers.getSuggestions)({
    datasourceMap,
    datasourceStates,
    visualizationMap,
    activeVisualization: initialVisualization,
    visualizationState: undefined,
    visualizeTriggerFieldContext: context,
    dataViews
  });
  if (!suggestions.length) return [];
  const activeVisualization = suggestions[0];
  if (activeVisualization.incomplete || excludedVisualizations !== null && excludedVisualizations !== void 0 && excludedVisualizations.includes(activeVisualization.visualizationId)) {
    return [];
  }
  // compute the rest suggestions depending on the active one and filter out the lnsLegacyMetric
  const newSuggestions = (0, _suggestion_helpers.getSuggestions)({
    datasourceMap,
    datasourceStates: {
      textBased: {
        isLoading: false,
        state: activeVisualization.datasourceState
      }
    },
    visualizationMap,
    activeVisualization: visualizationMap[activeVisualization.visualizationId],
    visualizationState: activeVisualization.visualizationState,
    dataViews
  }).filter(sug => !sug.hide && sug.visualizationId !== 'lnsLegacyMetric');
  const chartType = preferredChartType === null || preferredChartType === void 0 ? void 0 : preferredChartType.toLowerCase();

  // to return line / area instead of a bar chart
  const xyResult = (0, _helpers.switchVisualizationType)({
    visualizationMap,
    suggestions: newSuggestions,
    targetTypeId: chartType,
    familyType: 'lnsXY',
    shouldSwitch: ['area', 'line'].some(type => chartType === null || chartType === void 0 ? void 0 : chartType.includes(type))
  });
  if (xyResult) return xyResult;

  // to return a donut instead of a pie chart
  const pieResult = (0, _helpers.switchVisualizationType)({
    visualizationMap,
    suggestions: newSuggestions,
    targetTypeId: chartType,
    familyType: 'lnsPie',
    shouldSwitch: preferredChartType === _visualizationUtils.ChartType.Donut
  });
  if (pieResult) return pieResult;

  // in case the user asks for another type (except from area, line) check if it exists
  // in suggestions and return this instead
  const suggestionsList = [activeVisualization, ...newSuggestions];
  if (suggestionsList.length > 1 && preferredChartType) {
    const compatibleSuggestion = suggestionsList.find(s => s.title.includes(preferredChartType) || s.visualizationId.includes(preferredChartType));
    if (compatibleSuggestion) {
      const suggestion = preferredVisAttributes ? (0, _helpers.mergeSuggestionWithVisContext)({
        suggestion: compatibleSuggestion,
        visAttributes: preferredVisAttributes,
        context
      }) : compatibleSuggestion;
      return [suggestion];
    }
  }

  // if there is no preference from the user, send everything
  // until we separate the text based suggestions logic from the dataview one,
  // we want to sort XY first
  const sortXYFirst = suggestionsList.sort((a, b) => a.visualizationId === 'lnsXY' ? -1 : 1);
  return sortXYFirst;
};
exports.suggestionsApi = suggestionsApi;