"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getDataLossWarning = exports.ChartSwitchOptionPrepend = exports.ChartOption = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _react2 = require("@emotion/react");
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ChartOption = ({
  option,
  searchValue = ''
}) => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    alignItems: "center",
    css: (0, _react2.css)`
        text-align: left;
      `
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: option.icon || 'empty'
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    "data-test-subj": "lnsChartSwitch-option-label"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiHighlight, {
    search: searchValue
  }, option.label)), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs",
    color: "subdued"
  }, option.description ? /*#__PURE__*/_react.default.createElement(_eui.EuiHighlight, {
    search: searchValue
  }, option.description) : null)));
};
exports.ChartOption = ChartOption;
const getDataLossWarning = dataLoss => {
  if (dataLoss === 'nothing') {
    return;
  }
  if (dataLoss === 'everything') {
    return _i18n.i18n.translate('xpack.lens.chartSwitch.dataLossEverything', {
      defaultMessage: 'Changing to this visualization clears the current configuration.'
    });
  }
  if (dataLoss === 'layers') {
    return _i18n.i18n.translate('xpack.lens.chartSwitch.dataLossLayersDescription', {
      defaultMessage: 'Changing to this visualization modifies currently selected layer`s configuration and removes all other layers.'
    });
  } else return _i18n.i18n.translate('xpack.lens.chartSwitch.dataLossColumns', {
    defaultMessage: `Changing to this visualization modifies the current configuration.`
  });
};
exports.getDataLossWarning = getDataLossWarning;
const CheckIcon = () => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "check",
    color: euiTheme.colors.darkestShade
  });
};
const DataLossWarning = ({
  content,
  id
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  if (!content) return null;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
    size: "m",
    "aria-label": content,
    type: "dot",
    color: euiTheme.colors.warning,
    content: content,
    iconProps: {
      'data-test-subj': `lnsChartSwitchPopoverAlert_${id}`
    }
  });
};
const ChartSwitchOptionPrepend = ({
  isChecked,
  dataLoss,
  subtypeId
}) => {
  const dataLossWarning = getDataLossWarning(dataLoss);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, isChecked && /*#__PURE__*/_react.default.createElement(CheckIcon, null), dataLossWarning && /*#__PURE__*/_react.default.createElement(DataLossWarning, {
    content: dataLossWarning,
    id: subtypeId
  }), !dataLossWarning && !isChecked && /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "empty"
  }));
};
exports.ChartSwitchOptionPrepend = ChartSwitchOptionPrepend;