"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.mapToColumns = void 0;
var _i18n = require("@kbn/i18n");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const mapToColumns = exports.mapToColumns = {
  name: 'lens_map_to_columns',
  type: 'datatable',
  help: _i18n.i18n.translate('xpack.lens.functions.mapToColumns.help', {
    defaultMessage: 'A helper to transform a datatable to match Lens column definitions'
  }),
  args: {
    idMap: {
      types: ['string'],
      help: _i18n.i18n.translate('xpack.lens.functions.mapToColumns.idMap.help', {
        defaultMessage: 'A JSON encoded object in which keys are the datatable column ids and values are the Lens column definitions. Any datatable columns not mentioned within the ID map will be kept unmapped.'
      })
    },
    isTextBased: {
      types: ['boolean'],
      help: _i18n.i18n.translate('xpack.lens.functions.mapToColumns.isESQL.help', {
        defaultMessage: 'An optional flag to indicate if this is about the text based datasource.'
      })
    }
  },
  inputTypes: ['datatable'],
  async fn(...args) {
    var _args$;
    /** Build optimization: prevent adding extra code into initial bundle **/
    const {
      mapToOriginalColumns
    } = await Promise.resolve().then(() => _interopRequireWildcard(require('./map_to_columns_fn')));
    const {
      mapToOriginalColumnsTextBased
    } = await Promise.resolve().then(() => _interopRequireWildcard(require('./map_to_columns_fn_textbased')));
    return args !== null && args !== void 0 && (_args$ = args[1]) !== null && _args$ !== void 0 && _args$.isTextBased ? mapToOriginalColumnsTextBased(...args) : mapToOriginalColumns(...args);
  }
};