"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.graphState = void 0;
var _samples = require("../../util/samples");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const graphState = exports.graphState = {
  ecs: {
    value: (x, y) => y !== null && y !== void 0 ? y : x,
    default: () => ''
  },
  chunkSize: {
    value: (x, y) => y !== null && y !== void 0 ? y : x,
    default: () => 25
  },
  lastExecutedChain: {
    value: (x, y) => y !== null && y !== void 0 ? y : x,
    default: () => ''
  },
  rawSamples: {
    value: (x, y) => y !== null && y !== void 0 ? y : x,
    default: () => []
  },
  additionalProcessors: {
    value: (x, y) => y !== null && y !== void 0 ? y : x,
    default: () => []
  },
  prefixedSamples: {
    value: (x, y) => y !== null && y !== void 0 ? y : x,
    default: () => []
  },
  combinedSamples: {
    value: (x, y) => y !== null && y !== void 0 ? y : x,
    default: () => ''
  },
  sampleChunks: {
    value: (x, y) => y !== null && y !== void 0 ? y : x,
    default: () => []
  },
  exAnswer: {
    value: (x, y) => y !== null && y !== void 0 ? y : x,
    default: () => ''
  },
  packageName: {
    value: (x, y) => y !== null && y !== void 0 ? y : x,
    default: () => ''
  },
  dataStreamName: {
    value: (x, y) => y !== null && y !== void 0 ? y : x,
    default: () => ''
  },
  finalized: {
    value: (x, y) => y !== null && y !== void 0 ? y : x,
    default: () => false
  },
  currentMapping: {
    value: (x, y) => y !== null && y !== void 0 ? y : x,
    default: () => ({})
  },
  chunkMapping: {
    reducer: _samples.merge,
    default: () => ({})
  },
  finalMapping: {
    value: (x, y) => y !== null && y !== void 0 ? y : x,
    default: () => ({})
  },
  useFinalMapping: {
    value: (x, y) => y !== null && y !== void 0 ? y : x,
    default: () => false
  },
  hasTriedOnce: {
    value: (x, y) => y !== null && y !== void 0 ? y : x,
    default: () => false
  },
  currentPipeline: {
    value: (x, y) => y !== null && y !== void 0 ? y : x,
    default: () => ({})
  },
  duplicateFields: {
    value: (x, y) => y !== null && y !== void 0 ? y : x,
    default: () => []
  },
  missingKeys: {
    value: (x, y) => y !== null && y !== void 0 ? y : x,
    default: () => []
  },
  invalidEcsFields: {
    value: (x, y) => y !== null && y !== void 0 ? y : x,
    default: () => []
  },
  results: {
    value: (x, y) => y !== null && y !== void 0 ? y : x,
    default: () => ({})
  },
  samplesFormat: {
    value: (x, y) => y !== null && y !== void 0 ? y : x,
    default: () => ({
      name: 'json'
    })
  },
  ecsVersion: {
    value: (x, y) => y !== null && y !== void 0 ? y : x,
    default: () => '8.11.0'
  }
};