"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DocsLinkSubtitle = void 0;
var _react = _interopRequireDefault(require("react"));
var _public = require("@kbn/kibana-react-plugin/public");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DocsLinkSubtitle = exports.DocsLinkSubtitle = /*#__PURE__*/_react.default.memo(() => {
  const {
    docLinks
  } = (0, _public.useKibana)().services;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    color: "subdued"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.integrationAssistant.createIntegrationUpload.uploadHelpText",
    defaultMessage: "For more information, refer to {link}",
    values: {
      link: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        href: docLinks === null || docLinks === void 0 ? void 0 : docLinks.links.integrationDeveloper.upload,
        target: "_blank"
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.integrationAssistant.createIntegrationUpload.documentation",
        defaultMessage: "Upload an Integration"
      }))
    }
  }));
});
DocsLinkSubtitle.displayName = 'DocsLinkSubtitle';