"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TITLE_LABEL = exports.TITLE = exports.PREVIEW_TOOLTIP = exports.PREVIEW = exports.LOGO_LABEL = exports.LOGO_ERROR = exports.LOGO_DESCRIPTION = exports.DESCRIPTION_LABEL = exports.DESCRIPTION = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const TITLE = exports.TITLE = _i18n.i18n.translate('xpack.integrationAssistant.step.integration.title', {
  defaultMessage: 'Integration details'
});
const DESCRIPTION = exports.DESCRIPTION = _i18n.i18n.translate('xpack.integrationAssistant.step.integration.description', {
  defaultMessage: 'Name your integration, give it a description, and (optional) add a logo'
});
const TITLE_LABEL = exports.TITLE_LABEL = _i18n.i18n.translate('xpack.integrationAssistant.step.integration.integrationTitle', {
  defaultMessage: 'Title'
});
const DESCRIPTION_LABEL = exports.DESCRIPTION_LABEL = _i18n.i18n.translate('xpack.integrationAssistant.step.integration.integrationDescription', {
  defaultMessage: 'Description'
});
const LOGO_LABEL = exports.LOGO_LABEL = _i18n.i18n.translate('xpack.integrationAssistant.step.integration.logo.label', {
  defaultMessage: 'Logo (optional)'
});
const LOGO_DESCRIPTION = exports.LOGO_DESCRIPTION = _i18n.i18n.translate('xpack.integrationAssistant.step.integration.logo.description', {
  defaultMessage: 'Drag and drop a .svg file or Browse files'
});
const PREVIEW = exports.PREVIEW = _i18n.i18n.translate('xpack.integrationAssistant.step.integration.preview', {
  defaultMessage: 'Preview'
});
const PREVIEW_TOOLTIP = exports.PREVIEW_TOOLTIP = _i18n.i18n.translate('xpack.integrationAssistant.step.integration.previewTooltip', {
  defaultMessage: 'This is a preview of the integration card for the integrations catalog'
});
const LOGO_ERROR = exports.LOGO_ERROR = _i18n.i18n.translate('xpack.integrationAssistant.step.integration.logo.error', {
  defaultMessage: 'Error processing logo file'
});