"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getLangSmithOptions = void 0;
var _constants = require("@kbn/elastic-assistant/impl/assistant_context/constants");
var _public = require("@kbn/kibana-utils-plugin/public");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const sessionStorage = new _public.Storage(window.sessionStorage);

/**
 * Retrieves the LangSmith options from the AI Settings.
 */
const getLangSmithOptions = (nameSpace = _constants.DEFAULT_ASSISTANT_NAMESPACE) => {
  // Get the LangSmith options stored by the AI Settings using the assistant context
  // TODO: Encapsulate all AI Settings logic in a generic place.
  const sessionStorageTraceOptions = sessionStorage.get(`${nameSpace}.${_constants.TRACE_OPTIONS_SESSION_STORAGE_KEY}`);
  if (!sessionStorageTraceOptions) {
    return;
  }
  return {
    projectName: sessionStorageTraceOptions.langSmithProject,
    apiKey: sessionStorageTraceOptions.langSmithApiKey
  };
};
exports.getLangSmithOptions = getLangSmithOptions;