"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SectionTitle = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _react2 = require("@emotion/react");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const contentCss = (0, _react2.css)`
  width: 100%;
  max-width: 47em;
`;
const titleCss = (0, _react2.css)`
  text-align: center;
`;
const SectionTitle = exports.SectionTitle = /*#__PURE__*/_react.default.memo(({
  title,
  description
}) => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    alignItems: "center",
    justifyContent: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    css: contentCss
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "l"
  }, /*#__PURE__*/_react.default.createElement("h1", {
    css: titleCss
  }, title))), description && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    css: contentCss
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    textAlign: "center",
    color: "subdued"
  }, description)));
});
SectionTitle.displayName = 'SectionTitle';