"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ShardFailureFlyout = ShardFailureFlyout;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _shard_failure_table = require("./shard_failure_table");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

function ShardFailureFlyout({
  failures,
  onClose
}) {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlyout, {
    onClose: onClose,
    ownFocus: false,
    hideCloseButton: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, {
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("h1", null, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    iconType: "sortLeft",
    onClick: onClose
  }), _i18n.i18n.translate('inspector.requests.clusters.shards.flyoutTitle', {
    defaultMessage: '{failedShardCount} failed {failedShardCount, plural, one {shard} other {shards}}',
    values: {
      failedShardCount: failures.length
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, null, /*#__PURE__*/_react.default.createElement(_shard_failure_table.ShardFailureTable, {
    failures: failures
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutFooter, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    iconType: "sortLeft",
    onClick: onClose,
    flush: "left"
  }, _i18n.i18n.translate('inspector.requests.clusters.shards.backButtonLabel', {
    defaultMessage: 'Back'
  }))));
}