"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getErrorMessage = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getErrorMessage = error => {
  if (error.statusCode === 403) {
    return /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ingestPipelines.manageProcessors.deniedPrivilegeDescription",
      defaultMessage: "To manage geoIP databases, you must have the {manage} cluster privilege.",
      values: {
        manage: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, "manage")
      }
    });
  }
  return error.message;
};
exports.getErrorMessage = getErrorMessage;