"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UserAgent = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _shared_imports = require("../../../../../../shared_imports");
var _shared = require("./shared");
var _ignore_missing_field = require("./common_fields/ignore_missing_field");
var _field_name_field = require("./common_fields/field_name_field");
var _target_field = require("./common_fields/target_field");
var _properties_field = require("./common_fields/properties_field");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const propertyOptions = [{
  label: 'name'
}, {
  label: 'os'
}, {
  label: 'device'
}, {
  label: 'original'
}, {
  label: 'version'
}];
const fieldsConfig = {
  /* Optional fields config */
  regex_file: {
    type: _shared_imports.FIELD_TYPES.TEXT,
    serializer: _shared.from.emptyStringToUndefined,
    deserializer: String,
    label: _i18n.i18n.translate('xpack.ingestPipelines.pipelineEditor.userAgentForm.regexFileFieldLabel', {
      defaultMessage: 'Regex file (optional)'
    }),
    helpText: _i18n.i18n.translate('xpack.ingestPipelines.pipelineEditor.userAgentForm.regexFileFieldHelpText', {
      defaultMessage: 'File containing the regular expressions used to parse the user agent string.'
    })
  },
  extract_device_type: {
    type: _shared_imports.FIELD_TYPES.TOGGLE,
    defaultValue: false,
    deserializer: _shared.to.booleanOrUndef,
    serializer: _shared.from.undefinedIfValue(false),
    helpText: _i18n.i18n.translate('xpack.ingestPipelines.pipelineEditor.userAgentForm.extractDeviceTypeFieldHelpText', {
      defaultMessage: 'Extracts device type from the user agent string.'
    })
  }
};
const UserAgent = () => {
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_field_name_field.FieldNameField, {
    helpText: _i18n.i18n.translate('xpack.ingestPipelines.pipelineEditor.userAgentForm.fieldNameHelpText', {
      defaultMessage: 'Field containing the user agent string.'
    })
  }), /*#__PURE__*/_react.default.createElement(_shared_imports.UseField, {
    config: fieldsConfig.regex_file,
    component: _shared_imports.Field,
    path: "fields.regex_file",
    "data-test-subj": "regexFileField"
  }), /*#__PURE__*/_react.default.createElement(_target_field.TargetField, {
    helpText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ingestPipelines.pipelineEditor.userAgentForm.targetFieldHelpText",
      defaultMessage: "Output field. Defaults to {defaultField}.",
      values: {
        defaultField: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, 'user_agent')
      }
    })
  }), /*#__PURE__*/_react.default.createElement(_properties_field.PropertiesField, {
    helpText: _i18n.i18n.translate('xpack.ingestPipelines.pipelineEditor.userAgentForm.propertiesFieldHelpText', {
      defaultMessage: 'Properties added to the target field.'
    }),
    euiFieldProps: {
      options: propertyOptions,
      noSuggestions: false,
      'data-test-subj': 'propertiesValueField'
    }
  }), /*#__PURE__*/_react.default.createElement(_shared_imports.UseField, {
    config: fieldsConfig.extract_device_type,
    component: _shared_imports.ToggleField,
    path: "fields.extract_device_type",
    "data-test-subj": "extractDeviceTypeSwitch",
    euiFieldProps: {
      label: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        gutterSize: "xs"
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.ingestPipelines.pipelineEditor.userAgentForm.extractDeviceNameFieldText",
        defaultMessage: "Extract device type"
      })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiBetaBadge, {
        size: "s",
        label: "Beta",
        tooltipContent: _i18n.i18n.translate('xpack.ingestPipelines.pipelineEditor.userAgentForm.extractDeviceNameTooltipText', {
          defaultMessage: 'This functionality is in beta and is subject to change.'
        })
      })))
    }
  }), /*#__PURE__*/_react.default.createElement(_ignore_missing_field.IgnoreMissingField, null));
};
exports.UserAgent = UserAgent;