"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DateProcessor = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _shared_imports = require("../../../../../../shared_imports");
var _shared = require("./shared");
var _field_name_field = require("./common_fields/field_name_field");
var _target_field = require("./common_fields/target_field");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const {
  minLengthField
} = _shared_imports.fieldValidators;
const fieldsConfig = {
  /* Required fields config */
  formats: {
    type: _shared_imports.FIELD_TYPES.COMBO_BOX,
    deserializer: _shared.to.arrayOfStrings,
    label: _i18n.i18n.translate('xpack.ingestPipelines.pipelineEditor.dateForm.formatsFieldLabel', {
      defaultMessage: 'Formats'
    }),
    helpText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ingestPipelines.pipelineEditor.dateForm.formatsFieldHelpText",
      defaultMessage: "Expected date formats. Provided formats are applied sequentially. Accepts a Java time pattern or one of the following formats: {allowedFormats}.",
      values: {
        allowedFormats: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, 'ISO8601'), ",", /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, 'UNIX'), ",", /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, 'UNIX_MS'), ",", /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, 'TAI64N'))
      }
    }),
    validations: [{
      validator: minLengthField({
        length: 1,
        message: _i18n.i18n.translate('xpack.ingestPipelines.pipelineEditor.dateForm.formatsRequiredError', {
          defaultMessage: 'A value for formats is required.'
        })
      })
    }]
  },
  /* Optional fields config */
  timezone: {
    type: _shared_imports.FIELD_TYPES.TEXT,
    serializer: _shared.from.emptyStringToUndefined,
    label: _i18n.i18n.translate('xpack.ingestPipelines.pipelineEditor.dateForm.timezoneFieldLabel', {
      defaultMessage: 'Timezone (optional)'
    }),
    helpText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ingestPipelines.pipelineEditor.dateForm.timezoneHelpText",
      defaultMessage: "Timezone for the date. Defaults to {timezone}.",
      values: {
        timezone: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, 'UTC')
      }
    })
  },
  locale: {
    type: _shared_imports.FIELD_TYPES.TEXT,
    serializer: _shared.from.emptyStringToUndefined,
    label: _i18n.i18n.translate('xpack.ingestPipelines.pipelineEditor.dateForm.localeFieldLabel', {
      defaultMessage: 'Locale (optional)'
    }),
    helpText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ingestPipelines.pipelineEditor.dateForm.localeHelpText",
      defaultMessage: "Locale for the date. Useful when parsing month or day names. Defaults to {timezone}.",
      values: {
        timezone: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, 'ENGLISH')
      }
    })
  },
  output_format: {
    type: _shared_imports.FIELD_TYPES.TEXT,
    serializer: _shared.from.emptyStringToUndefined,
    label: _i18n.i18n.translate('xpack.ingestPipelines.pipelineEditor.dateForm.outputFormatFieldLabel', {
      defaultMessage: 'Output format (optional)'
    }),
    helpText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ingestPipelines.pipelineEditor.dateForm.outputFormatHelpText",
      defaultMessage: "Format to use when writing the date to {targetField}. Must be a valid Java time pattern. Defaults to {defaultFormat}.",
      values: {
        targetField: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, 'target_field'),
        defaultFormat: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, `yyyy-MM-dd'T'HH:mm:ss.SSSXXX`)
      }
    })
  }
};

/**
 * Disambiguate from global Date object
 */
const DateProcessor = () => {
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_field_name_field.FieldNameField, {
    helpText: _i18n.i18n.translate('xpack.ingestPipelines.pipelineEditor.dateForm.fieldNameHelpText', {
      defaultMessage: 'Field to convert.'
    })
  }), /*#__PURE__*/_react.default.createElement(_shared_imports.UseField, {
    "data-test-subj": "formatsValueField",
    config: fieldsConfig.formats,
    component: _shared_imports.ComboBoxField,
    path: "fields.formats"
  }), /*#__PURE__*/_react.default.createElement(_target_field.TargetField, {
    helpText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ingestPipelines.pipelineEditor.dateForm.targetFieldHelpText",
      defaultMessage: "Output field. If empty, the input field is updated in place. Defaults to {defaultField}.",
      values: {
        defaultField: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, '@timestamp')
      }
    })
  }), /*#__PURE__*/_react.default.createElement(_shared_imports.UseField, {
    "data-test-subj": "timezoneField",
    config: fieldsConfig.timezone,
    component: _shared_imports.Field,
    path: "fields.timezone"
  }), /*#__PURE__*/_react.default.createElement(_shared_imports.UseField, {
    "data-test-subj": "localeField",
    config: fieldsConfig.locale,
    component: _shared_imports.Field,
    path: "fields.locale"
  }), /*#__PURE__*/_react.default.createElement(_shared_imports.UseField, {
    "data-test-subj": "outputFormatField",
    config: fieldsConfig.output_format,
    component: _shared_imports.Field,
    path: "fields.output_format"
  }));
};
exports.DateProcessor = DateProcessor;