"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LoadFromJsonButton = void 0;
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _modal_provider = require("./modal_provider");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const i18nTexts = {
  buttonLabel: _i18n.i18n.translate('xpack.ingestPipelines.pipelineEditor.loadFromJson.buttonLabel', {
    defaultMessage: 'Import processors'
  })
};
const LoadFromJsonButton = ({
  onDone
}) => {
  return /*#__PURE__*/_react.default.createElement(_modal_provider.ModalProvider, {
    onDone: onDone
  }, openModal => {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      size: "s",
      onClick: openModal,
      iconType: "importAction"
    }, i18nTexts.buttonLabel);
  });
};
exports.LoadFromJsonButton = LoadFromJsonButton;