"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.metricsExplorerViewSavedObjectType = exports.metricsExplorerViewSavedObjectName = void 0;
var _Either = require("fp-ts/lib/Either");
var _pipeable = require("fp-ts/lib/pipeable");
var _types = require("./types");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const metricsExplorerViewSavedObjectName = exports.metricsExplorerViewSavedObjectName = 'metrics-explorer-view';
const getMetricsExplorerViewTitle = savedObject => (0, _pipeable.pipe)(_types.metricsExplorerViewSavedObjectRT.decode(savedObject), (0, _Either.fold)(() => `Metrics explorer view [id=${savedObject.id}]`, ({
  attributes: {
    name
  }
}) => name));
const metricsExplorerViewSavedObjectType = exports.metricsExplorerViewSavedObjectType = {
  name: metricsExplorerViewSavedObjectName,
  hidden: false,
  namespaceType: 'single',
  management: {
    defaultSearchField: 'name',
    displayName: 'metrics explorer view',
    getTitle: getMetricsExplorerViewTitle,
    icon: 'metricsApp',
    importableAndExportable: true
  },
  mappings: {
    dynamic: false,
    properties: {}
  }
};