"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getInventoryModelAggregations = exports.getFilterByIntegration = exports.getDocumentsFilter = void 0;
var _common = require("@kbn/metrics-data-access-plugin/common");
var _server = require("@kbn/observability-plugin/server");
var _common2 = require("@kbn/apm-data-access-plugin/common");
var _constants = require("../../../../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getFilterByIntegration = integration => {
  return {
    bool: {
      should: [...(0, _server.termQuery)(_constants.EVENT_MODULE, integration), ...(0, _server.termQuery)(_constants.METRICSET_MODULE, integration)],
      minimum_should_match: 1
    }
  };
};
exports.getFilterByIntegration = getFilterByIntegration;
const getApmDocumentsFilter = async ({
  apmDataAccessServices,
  apmDocumentSources,
  start,
  end
}) => {
  const {
    preferredSource,
    documentTypeConfig
  } = apmDataAccessServices.getDocumentTypeConfig({
    start,
    end,
    documentTypes: [_common2.ApmDocumentType.TransactionMetric],
    documentSources: apmDocumentSources
  });
  return 'getQuery' in documentTypeConfig ? documentTypeConfig.getQuery(preferredSource.source.rollupInterval) : undefined;
};
const getDocumentsFilter = async ({
  apmDataAccessServices,
  apmDocumentSources,
  from,
  to
}) => {
  const filters = [getFilterByIntegration('system')];
  const apmDocumentsFilter = apmDataAccessServices && apmDocumentSources ? await getApmDocumentsFilter({
    apmDataAccessServices,
    apmDocumentSources,
    start: from,
    end: to
  }) : undefined;
  if (apmDocumentsFilter) {
    filters.push(apmDocumentsFilter);
  }
  return filters;
};
exports.getDocumentsFilter = getDocumentsFilter;
const getInventoryModelAggregations = (assetType, metrics) => {
  const inventoryModel = (0, _common.findInventoryModel)(assetType);
  return metrics.reduce((acc, metric) => {
    var _inventoryModel$metri;
    return (_inventoryModel$metri = inventoryModel.metrics.snapshot) !== null && _inventoryModel$metri !== void 0 && _inventoryModel$metri[metric] ? Object.assign(acc, inventoryModel.metrics.snapshot[metric]) : acc;
  }, {});
};
exports.getInventoryModelAggregations = getInventoryModelAggregations;