"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SteppedGradientLegend = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _common = require("@kbn/kibana-react-plugin/common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SteppedGradientLegend = ({
  legend,
  bounds,
  formatter
}) => {
  return /*#__PURE__*/_react.default.createElement(LegendContainer, null, /*#__PURE__*/_react.default.createElement(TickLabel, {
    value: 1,
    bounds: bounds,
    formatter: formatter
  }), /*#__PURE__*/_react.default.createElement(GradientContainer, null, legend.rules.slice().reverse().map((rule, index) => /*#__PURE__*/_react.default.createElement(GradientStep, {
    key: `step-${index}-${rule.value}`,
    style: {
      backgroundColor: rule.color
    }
  }))), /*#__PURE__*/_react.default.createElement(TickLabel, {
    value: 0,
    bounds: bounds,
    formatter: formatter
  }));
};
exports.SteppedGradientLegend = SteppedGradientLegend;
const TickLabel = ({
  value,
  bounds,
  formatter
}) => {
  const normalizedValue = value === 0 ? bounds.min : bounds.max * value;
  const label = formatter(normalizedValue);
  return /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs"
  }, label));
};
const LegendContainer = _common.euiStyled.div`
  position: relative;
  display: flex;
  flex-direction: column;
  justify-content: center;
  align-items: center;
`;
const GradientContainer = _common.euiStyled.div`
  height: 200px;
  width: 10px;
  display: flex;
  flex-direction: column;
  align-items: stretch;
`;
const GradientStep = _common.euiStyled.div`
  flex: 1 1 auto;
  &:first-child {
    border-radius: ${props => props.theme.eui.euiBorderRadius} ${props => props.theme.eui.euiBorderRadius} 0 0;
  }
  &:last-child {
    border-radius: 0 0 ${props => props.theme.eui.euiBorderRadius} ${props => props.theme.eui.euiBorderRadius};
  }
`;