"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Layout = void 0;
var _react = _interopRequireWildcard(require("react"));
var _useInterval = _interopRequireDefault(require("react-use/lib/useInterval"));
var _react2 = require("@emotion/react");
var _eui = require("@elastic/eui");
var _common = require("@kbn/kibana-react-plugin/common");
var _auto_sizer = require("../../../../components/auto_sizer");
var _nodes_overview = require("./nodes_overview");
var _calculate_bounds_from_nodes = require("../lib/calculate_bounds_from_nodes");
var _page = require("../../../../components/page");
var _use_waffle_time = require("../hooks/use_waffle_time");
var _use_waffle_filters = require("../hooks/use_waffle_filters");
var _use_waffle_options = require("../hooks/use_waffle_options");
var _types = require("../../../../common/inventory/types");
var _toolbar = require("./toolbars/toolbar");
var _view_switcher = require("./waffle/view_switcher");
var _create_inventory_metric_formatter = require("../lib/create_inventory_metric_formatter");
var _create_legend = require("../lib/create_legend");
var _use_waffle_view_state = require("../hooks/use_waffle_view_state");
var _bottom_drawer = require("./bottom_drawer");
var _legend_controls = require("./waffle/legend_controls");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const Layout = exports.Layout = /*#__PURE__*/_react.default.memo(({
  currentView,
  reload,
  interval,
  nodes,
  loading
}) => {
  var _legend$palette, _legend$steps, _legend$reverseColors;
  const [showLoading, setShowLoading] = (0, _react.useState)(true);
  const {
    metric,
    groupBy,
    sort,
    nodeType,
    changeView,
    view,
    autoBounds,
    boundsOverride,
    legend,
    changeBoundsOverride,
    changeAutoBounds,
    changeLegend
  } = (0, _use_waffle_options.useWaffleOptionsContext)();
  const {
    currentTime,
    jumpToTime,
    isAutoReloading
  } = (0, _use_waffle_time.useWaffleTimeContext)();
  const {
    applyFilterQuery
  } = (0, _use_waffle_filters.useWaffleFiltersContext)();
  const legendPalette = (_legend$palette = legend === null || legend === void 0 ? void 0 : legend.palette) !== null && _legend$palette !== void 0 ? _legend$palette : _use_waffle_options.DEFAULT_LEGEND.palette;
  const legendSteps = (_legend$steps = legend === null || legend === void 0 ? void 0 : legend.steps) !== null && _legend$steps !== void 0 ? _legend$steps : _use_waffle_options.DEFAULT_LEGEND.steps;
  const legendReverseColors = (_legend$reverseColors = legend === null || legend === void 0 ? void 0 : legend.reverseColors) !== null && _legend$reverseColors !== void 0 ? _legend$reverseColors : _use_waffle_options.DEFAULT_LEGEND.reverseColors;
  const AUTO_REFRESH_INTERVAL = 5 * 1000;
  const options = {
    formatter: _types.InfraFormatterType.percent,
    formatTemplate: '{{value}}',
    legend: (0, _create_legend.createLegend)(legendPalette, legendSteps, legendReverseColors),
    metric,
    sort,
    groupBy
  };
  (0, _useInterval.default)(() => {
    if (!loading) {
      jumpToTime(Date.now());
    }
  }, isAutoReloading ? AUTO_REFRESH_INTERVAL : null);
  const dataBounds = (0, _calculate_bounds_from_nodes.calculateBoundsFromNodes)(nodes);
  const bounds = autoBounds ? dataBounds : boundsOverride;
  const formatter = (0, _react.useCallback)(val => (0, _create_inventory_metric_formatter.createInventoryMetricFormatter)(options.metric)(val), [options.metric]);
  const {
    onViewChange
  } = (0, _use_waffle_view_state.useWaffleViewState)();
  (0, _react.useEffect)(() => {
    if (currentView) {
      onViewChange(currentView);
    }
  }, [currentView, onViewChange]);
  (0, _react.useEffect)(() => {
    // load snapshot data after default view loaded, unless we're not loading a view
    if (currentView != null) {
      reload();
    }
  }, [currentView, reload]);
  (0, _react.useEffect)(() => {
    setShowLoading(true);
  }, [options.metric, nodeType]);
  (0, _react.useEffect)(() => {
    const hasNodes = nodes && nodes.length;
    // Don't show loading screen when we're auto-reloading
    setShowLoading(!hasNodes);
  }, [nodes]);
  const handleLegendControlChange = (0, _react.useCallback)(opts => {
    changeBoundsOverride(opts.bounds);
    changeAutoBounds(opts.auto);
    changeLegend(opts.legend);
  }, [changeBoundsOverride, changeAutoBounds, changeLegend]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_page.PageContent, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(TopActionContainer, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween",
    alignItems: "center",
    gutterSize: "m"
  }, /*#__PURE__*/_react.default.createElement(_toolbar.Toolbar, {
    nodeType: nodeType,
    currentTime: currentTime
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    responsive: false,
    css: (0, _react2.css)`
                  margin: 0;
                  justify-content: flex-end;
                `
  }, view === 'map' && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_legend_controls.LegendControls, {
    options: legend != null ? legend : _use_waffle_options.DEFAULT_LEGEND,
    dataBounds: dataBounds,
    bounds: bounds,
    autoBounds: autoBounds,
    boundsOverride: boundsOverride,
    onChange: handleLegendControlChange
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_view_switcher.ViewSwitcher, {
    view: view,
    onChange: changeView
  }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    css: (0, _react2.css)`
              position: relative;
              flex: 1 1 auto;
            `
  }, /*#__PURE__*/_react.default.createElement(_auto_sizer.AutoSizer, {
    bounds: true
  }, ({
    bounds: {
      height = 0
    }
  }) => /*#__PURE__*/_react.default.createElement(_nodes_overview.NodesOverview, {
    nodes: nodes,
    options: options,
    nodeType: nodeType,
    loading: loading,
    showLoading: showLoading,
    reload: reload,
    onDrilldown: applyFilterQuery,
    currentTime: currentTime,
    view: view,
    autoBounds: autoBounds,
    boundsOverride: boundsOverride,
    formatter: formatter,
    bottomMargin: height,
    isAutoReloading: isAutoReloading,
    refreshInterval: AUTO_REFRESH_INTERVAL
  }))))), /*#__PURE__*/_react.default.createElement(_bottom_drawer.BottomDrawer, {
    interval: interval,
    formatter: formatter,
    view: view,
    nodeType: nodeType
  }));
});
const TopActionContainer = (0, _common.euiStyled)(_eui.EuiFlexItem)`
  padding: ${props => `${props.theme.eui.euiSizeM} 0`};
`;